float4x4 vert_mat;
float3x3 normal_mat;
float3	 diffuse;

/*
sampler smplr0 = sampler_state
{
	Texture = <texture0>;
	MinFilter = POINT;
//	MagFilter = LINEAR;
	MagFilter = POINT;
};

sampler smplr1 = sampler_state
{
	Texture = <texture1>;
	MinFilter = POINT;
//	MagFilter = LINEAR;
	MagFilter = POINT;
};
*/

struct v_out
{
	float4 pos : POSITION;
//	float2 uv : TEXCOORD0;
	float4 col : COLOR0;
};

v_out v_main
(
	float4 in_pos : POSITION,
//	float2 in_uv : TEXCOORD0
	float3 in_normal : NORMAL
)
{
	v_out ret;
	ret.pos = mul(in_pos, vert_mat);
//	ret.uv = in_uv;

	float3 light	= mul(normalize(float3(0.0f, 0.0f, -1.0f)), normal_mat);
	float3 normal	= mul(in_normal, normal_mat);

	float diffuse_scale
	=
	max
	(
		-dot
		(
			light,
			normal
		),
		0.0
	);

	ret.col = diffuse_scale*float4(diffuse, 1.0f);//float4(0.7f, 0.5f, 0.4f, 1.0f);

	return ret;
}

struct p_in
{
	float4 col : COLOR0;
};

struct p_out
{
	float4 color : COLOR0;
};

float clr;

p_out p_main(p_in in_v)
{
	p_out ret;
/*
//	float normal_buf = tex2D(smplr0, in_v.uv).r;
//	float4 material_buf = tex2D(smplr1, in_v.uv);

	float3 normal	= in_v.normal;
	float4 color	= float4(1.0f, 1.0f, 1.0f, 1.0f);
*/
	ret.color = in_v.col;//diffuse*color;
//	ret.color = float4(1.0f, 0.0f, 1.0f, 1.0f);
	
	return ret;
}

technique tech0
{
	pass p0
	{
		VertexShader = compile vs_2_0 v_main();
		PixelShader = compile ps_2_0 p_main();
	}
}
