
/*
GL_TEXTURE_RECTANGLE_NVgƂ
samplerRECT + texture2DRect
GL_TEXTURE_2DgƂ
sampler2D + texture2D
*/
uniform sampler2D texture0;
uniform sampler2D texture1;

uniform sampler2D env_tex;
uniform mat4 view_mat;
uniform mat3 normal_mat;

void main (void)
{
	float buf0 = texture2D(texture0, gl_TexCoord[0].xy).w;
	vec4 buf1 = texture2D(texture1, gl_TexCoord[0].xy);

//	vec3 normal = vec3((texture2DRect(texture0, gl_TexCoord[0].xy).xw - 0.5)*2.0, 0.0f);
	vec3 normal	= vec3((buf1.w-0.5)*2.0, (buf0-0.5)*2.0, 0.0);
	//Bug! normal.z is always positive. We need to remember sign of z.
	normal.z	= sqrt(1.0 - normal.x*normal.x - normal.y*normal.y);
	normal		= normal_mat * normal;
//	vec4 color	= texture2DRect(texture1, gl_TexCoord[0].xy);
	vec4 color	= vec4(buf1.xyz, 1.0);
//	vec3 light	= normalize(gl_LightSource[0].position.xyz);
	vec3 light	= normalize(vec3(0.0, -0.4, -0.6));
	light		= vec4(view_mat*vec4(light, 0.0)).xyz;
	float diffuse = max(-dot(light, normal), 0.0);

	vec4 c = texture2D(env_tex, vec2(normal.x/2.0+0.5, normal.y/2.0+0.5));

	gl_FragColor =  diffuse*color+c/* + gl_LightSource[0].ambient*/;
//	gl_FragColor = vec4(buf1.rgb, /*1.0, 1.0,*/ 1.0);;
}
