texture texture0;
texture texture1;
texture env_tex;

sampler smplr0 = sampler_state
{
	Texture = <texture0>;
	MinFilter = POINT;
//	MagFilter = LINEAR;
	MagFilter = POINT;
};

sampler smplr1 = sampler_state
{
	Texture = <texture1>;
	MinFilter = POINT;
//	MagFilter = LINEAR;
	MagFilter = POINT;
};

sampler smplr_env = sampler_state
{
	Texture = <env_tex>;
	MinFilter = POINT;
	MagFilter = POINT;
};

uniform float4x4 view_mat;
uniform float4x4 normal_mat;

struct v_out
{
	float4 pos : POSITION;
	float2 uv : TEXCOORD0;
};

v_out v_main(float4 in_pos : POSITION,
			 float2 in_uv : TEXCOORD0)
{
	v_out ret;
	ret.pos = in_pos;
	ret.uv = in_uv;

	return ret;
}


struct p_out
{
	float4 color : COLOR0;
};

float clr;

p_out p_main(v_out in_v)
{
	p_out ret;

	float normal_buf = tex2D(smplr0, in_v.uv).r;
	float4 material_buf = tex2D(smplr1, in_v.uv);

	float3 normal	= float3((material_buf.a-0.5)*2.0, (normal_buf-0.5)*2.0, 0.0);
	normal.z		= sqrt(1.0 - normal.x*normal.x - normal.y*normal.y);
	normal			= mul(normal_mat, normal);
	float4 color	= float4(material_buf.rgb, 1.0);
	float3 light	= normalize(float3(-0.2f, -0.4f, -0.6f));
	light			= float4(mul(view_mat, float4(light, 0.0))).xyz;
	float diffuse	= max(-dot(light, normal), 0.0);

	float4 c = tex2D(smplr_env, float2(normal.x/2.0+0.5, normal.y/2.0+0.5));

	ret.color = diffuse*color+c;
	
	return ret;
}

technique tech0
{
	pass p0
	{
		VertexShader = compile vs_2_0 v_main();
		PixelShader = compile ps_2_0 p_main();
	}
}
