#ifndef DX_HANDLER_HPP
#define DX_HANDLER_HPP

#include "handler.hpp"

class dx_handler_impl : public handler_dynamic_base
{
public:

	dx_handler_impl();
	~dx_handler_impl();

protected:

	void uninit(gpuppur::gpuppurut&);
	bool init(gpuppur::gpuppurut&);
	void draw(gpuppur::gpuppurut& gut);
};

template<bool Implement>
class dx_handler : public dx_handler_impl
{
public:
	dx_handler()
	{
	}

	~dx_handler()
	{
	}

protected:

	gpuppur::gpuppur_virtual& get_gpuppur()
	{
		return this->my_gpuppur;
	}

	gpuppur::gpuppurut& get_gpuppurut()
	{
		return this->my_gut;
	}

	typename boost::mpl::if_c
	<
		Implement,
		gpuppur::dx_raytracer,
		gpuppur::dx_rasterizer
	>::type					my_gpuppur;
	gpuppur::gglut			my_gut;
};

#endif
