#include "stdafx.h"
#include "gl_handler.hpp"

using namespace gpuppur;
using namespace std;

void gl_handler_impl::uninit(gpuppurut&)
{
}

bool gl_handler_impl::init(gpuppurut&)
{
	GLenum err = glewInit();
	if (GLEW_OK != err)
	{
		cerr << "Failed to glewInit()" << endl;
		return false;
	}

	if (!GLEW_VERSION_2_0)
	{
		cerr << "OpenGL2.0 or higher is needed." << endl;
		return false;
	}

	if(!GLEW_ARB_texture_rectangle)
	{
		cerr << "GL_EXT_texture_rectangle is needed." << endl;
		return false;
	}

	if(!GLEW_ARB_pixel_buffer_object)
	{
		cerr << "GL_ARB_pixel_buffer_object is needed." << endl;
		return false;
	}

	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	float AmbientColor[]	= { 0.2f, 0.2f, 0.2f, 0.0f };		glLightfv(GL_LIGHT0, GL_AMBIENT, AmbientColor);
	float DiffuseColor[]	= { 1.0f, 1.0f, 1.0f, 0.0f };		glLightfv(GL_LIGHT0, GL_DIFFUSE, DiffuseColor);
	float Position[]		= { 1.0f, -1.0f, -1.0f, 0.0f };		glLightfv(GL_LIGHT0, GL_POSITION, Position);
//	glDisable(GL_LIGHTING);
//	glDisable(GL_LIGHT0);

	return true;
}

void gl_handler_impl::draw(gpuppurut&/* gut*/)
{
	GL_ERROR_ASSERT;

	//rasterilze something.

//	glDisable(GL_TEXTURE_RECTANGLE_NV);
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_LIGHT0);
	glDisable(GL_LIGHTING);
	glDisable(GL_CULL_FACE);
	glDisable(GL_DEPTH_TEST);

	GL_ERROR_ASSERT;
}

#if 0
void gl_handler_impl::impl_resize(gpuppurut& /*gut*/, int /*width*/, int /*height*/)
{
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
//	gluPerspective(45.0, (double)width/height, 1.0, 1024.0);
	glViewport(0, 0, width, height);

	glMatrixMode(GL_MODELVIEW);
}
#endif
