#ifndef GL_HANDLER_HPP
#define GL_HANDLER_HPP

#include "handler.hpp"

class gl_handler_impl : public handler_dynamic_base
{
public:

	gl_handler_impl()
	{
	}

	~gl_handler_impl()
	{
	}

protected:

	void uninit(gpuppur::gpuppurut& gut);
	bool init(gpuppur::gpuppurut& gut);
	void draw(gpuppur::gpuppurut& gut);
};

template<bool Implement>
class gl_handler : public gl_handler_impl
{
public:

	gl_handler()
	{
	}

	~gl_handler()
	{
	}

protected:

	gpuppur::gpuppur_virtual& get_gpuppur()
	{
		return this->my_gpuppur;
	}

	gpuppur::gpuppurut& get_gpuppurut()
	{
		return this->my_gut;
	}

	typename boost::mpl::if_c
	<
		Implement,
		gpuppur::gl_raytracer,
		gpuppur::gl_rasterizer
	>::type					my_gpuppur;
	gpuppur::gglut			my_gut;
};

#endif
