#include "stdafx.h"

#include <gpuppur/utility/begin_suppress_warnings_from_others_code.hpp>
#include <boost/throw_exception.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/mpl/int.hpp>
#include <boost/mpl/list.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/tuple/tuple.hpp>
#include <gpuppur/utility/end_suppress_warnings.hpp>

#include "handler/gl_handler.hpp"
#include <gpuppur/utility/frame_per_second.hpp>
//#include <gpuppur/3dmath/math_test.hpp>

#ifdef _MSC_VER
#include "handler/dx_handler.hpp"
#endif

using namespace gpuppur;
using namespace std;
using namespace boost;

template<bool IsSexual>
class impls
{
public:

	typedef impls<IsSexual>	this_type;

protected:

	typedef
		tuple
		<
		//	gpuppurut_handler<handler_static<true, false> >,
		//	gpuppurut_handler<handler_static<false, true> >,
			gpuppurut_handler<handler_static<true, true> >
		>
		sexy_impls;

	typedef
	gpuppurut_handler
	<
		handler_dynamic
		<
			boost::mpl::list
			<
				gl_handler<true>,
				dx_handler<true>
			>
		>
	>	dynamic_handler;

	struct dynamic_impls
	{
		template<int N>
		dynamic_handler& get()
		{
			return *this->impls[N];
		}

		dynamic_impls()
		{
			for(int i=0; i<dynamic_impls::num_impls; ++i)
			{
				this->impls.push_back
				(
					boost::shared_ptr
					<
						dynamic_handler
					>(new dynamic_handler())
				);
			}
		}

		std::vector
		<
			boost::shared_ptr<dynamic_handler>
		>	impls;
		const static int num_impls = 1;
	};

	typedef
	typename boost::mpl::if_c
	<
		IsSexual,
		sexy_impls,
		dynamic_impls
	>::type	this_data;

	const static int num_impl
	= IsSexual ?
		boost::tuples::length<sexy_impls>::value
		:
		dynamic_impls::num_impls;

private:

	void show_initialize_err(gpuppurut::ReturnCode ret)
	{
		std::cerr << "Failed to initialize gpuppurut.\n" << std::endl;

		switch(ret)
		{
		case gpuppurut::ReturnCode::INCORRECTVERSION:
			std::cerr
				<<
				"Installed DirectX version is different from sdk version."
				<< std::endl;
			break;

		case gpuppurut::ReturnCode::CREATING3DDEVICE:
			cerr << "Failed to create direct3d device." << endl;
			break;

		case gpuppurut::ReturnCode::NORUNTIME:
			cerr << "DirectX runtime is not installed." << endl;
			break;
		}
		::getchar();
	}

	bool impl_initialize(int, int, mpl::int_<this_type::num_impl>)
	{
		return true;
	}

	template<int N>
	bool impl_initialize(int width, int height, mpl::int_<N>)
	{
		gpuppurut::ReturnCode ret
		=
		this->data.get<N>().get_gpuppurut().initialize
		(
			width, height, std::wstring(L"GPUPPUR")+lexical_cast<std::wstring>(N)
		);
		if(ret != gpuppurut::ReturnCode::OK)
		{
			this->data.get<N>().get_gpuppurut().uninitialize();
			this->show_initialize_err(ret);

			return false;
		}

		return	this->impl_initialize(width, height, mpl::int_<N+1>());
	}

	bool impl_process(mpl::int_<this_type::num_impl>)
	{
		return false;
	}

	template<int N>
	bool impl_process(mpl::int_<N>)
	{
		if(this->data.get<N>().get_gpuppurut().get_is_closed())
		{
			return this->impl_process(mpl::int_<N+1>());
		}

		if
		(
			this->data.get<N>().get_gpuppurut().get_is_visible()
			!=
			gpuppurut::ReturnCode::Visible
		)
		{
			this->impl_process(mpl::int_<N+1>());
			return true;
		}

		this->data.get<N>().get_gpuppurut().redraw();

		this->impl_process(mpl::int_<N+1>());

		return true;
	}

public:

	bool initialize(int width, int height)
	{
		return this->impl_initialize(width, height, mpl::int_<0>());
	}

	bool process()
	{
		return this->impl_process(mpl::int_<0>());
	}

protected:

	this_data data;
};

namespace boost
{
	void throw_exception(std::exception const &)
	{
		assert(false && "there is a exception");
	}
}

int _tmain(int argc, _TCHAR* argv[])
{
	setlocale(LC_ALL, "");
//	math_test();

/*	typedef gpuppurut_handler
	<
		handler_dynamic
		<
			boost::mpl::list<gl_handler>
		>
	>	impl_handler;
*/

	gglut::global_initialize(&argc, argv);
	gdxut::global_initialize(&argc, argv);
//	mygut::global_initialize(&argc, argv);


	typedef impls<true>	impls_type;

	impls_type	impls;

	if(!impls.initialize(512, 512))
	{
		return 1;
	}

	while(impls.process())
	{
		gpuppur::frame_per_second::probe();

		gglut::handle_event();
	}

	return 0;
}
