#include <boost/assert.hpp>
#include <boost/mpl/list.hpp>
#include <boost/mpl/reverse_fold.hpp>
#include <boost/mpl/int.hpp>
#include <boost/mpl/is_sequence.hpp>
#include <boost/mpl/size.hpp>
#include <boost/mpl/assert.hpp>

template<template<class> class BaseTemplate>
class null_di : public BaseTemplate<null_di<BaseTemplate> >
{
public:
	null_di() : BaseTemplate<null_di>(*this)
	{
	}

	null_di* get()
	{
			return	this;
	}
};

class recursive_object
{
public:

	template<typename This, class Object>
	class apply
	{
	public:
		Object	obj;
		This	this_obj;

		typedef apply<This, Object> type;
	};
};

template <class Sequence, template<class> class BaseTemplate>
class dynamic_impl : public BaseTemplate<dynamic_impl<Sequence, BaseTemplate> >
{
	BOOST_MPL_ASSERT_MSG(boost::mpl::is_sequence<Sequence>::type::value,
						Sequence_must_be_mpl_sequence_type, (Sequence));

public:
	typedef BaseTemplate<dynamic_impl<Sequence, BaseTemplate> >	ThisBase;
	typedef BaseTemplate<null_di<BaseTemplate> >					Base;

	dynamic_impl():ThisBase(*this), pinstance(&this->instances.obj)
	{
	}

	Base* get()
	{
		return this->pinstance;
	}

	void set(int index)
	{
		this->pinstance = dynamic_impl::get(index, this->instances);
	}

	template<int _index>
	Base* get(boost::mpl::int_<_index>)
	{
		return dynamic_impl::get(boost::mpl::int_<_index>(), this->instances);
	}

private:

	typedef typename boost::mpl::reverse_fold<Sequence, boost::mpl::void_, recursive_object >::type	recursive;

	template<int _index, class _ro>
	static Base* get(boost::mpl::int_<_index>, _ro& ro)
	{
		BOOST_MPL_ASSERT_RELATION(_index, <, boost::mpl::size<Sequence>::value);
		return get(boost::mpl::int_<_index-1>(), ro.this_obj);
	}

	template<class _ro>
	static Base* get(boost::mpl::int_<0>, _ro& ro)
	{
		return &ro.obj;
	}

	template<class RecursiveObject>
	static Base* get(int index, RecursiveObject& ro)
	{
		return index==0 ? &ro.obj : dynamic_impl::get(index-1, ro.this_obj);
	}

	static Base* get(int, boost::mpl::void_)
	{
		assert(false);
		return "zc" ? NULL: "" ? NULL : NULL;
	}

	recursive	instances;
	Base*		pinstance;
};
