#include "../gpuppurut/config.h"
#include "stdafx.h"

using namespace gpuppur;
using namespace std;

namespace
{
	std::map<HWND, gdxut*> handle_map;
	typedef std::map<HWND, gdxut*>::iterator handle_map_itr;

	template<typename _wndclassex, typename _char>
	void setWndClass(_wndclassex* wndclass, const _char* className, HINSTANCE hinst)
	{
		wndclass->cbSize = sizeof(_wndclassex); 

		wndclass->style			= CS_HREDRAW | CS_VREDRAW;
		wndclass->lpfnWndProc	= (WNDPROC)directx_wnd_proc;
		wndclass->cbClsExtra	= 0;
		wndclass->cbWndExtra	= 0;
		wndclass->hInstance		= hinst;
		wndclass->hIcon			= NULL;
		wndclass->hCursor		= LoadCursor(NULL, IDC_ARROW);
		wndclass->hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
		wndclass->lpszMenuName	= NULL;
		wndclass->lpszClassName	= className;
		wndclass->hIconSm		= NULL;
	}

	/// Calculate window width from client area width.
	int to_window_width(int client_width)
	{
		return client_width + ( GetSystemMetrics( SM_CXSIZEFRAME ) )*2;
	}

	/// Calculate window height from client area height.
	int to_window_height(int client_height)
	{
		return client_height + ( GetSystemMetrics( SM_CYSIZEFRAME ) )*2 +
								GetSystemMetrics( SM_CYCAPTION );
	}

	/// Calculate client area width from window width.
	int to_client_width(int window_width)
	{
		return window_width - ( GetSystemMetrics( SM_CXSIZEFRAME ) )*2;
	}

	/// Calculate client area height from window height.
	int to_client_height(int window_height)
	{
		return window_height - ( GetSystemMetrics( SM_CYSIZEFRAME ) )*2 -
								GetSystemMetrics( SM_CYCAPTION );
	}
};

LRESULT CALLBACK directx_wnd_proc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	//DirectXDocumentɂƁAIDirect3DDevice9::Reset()Ă񂾂ƂÅ֐߂O
	//bZ[WĂ邱Ƃ炵B
	//IDirect3DDevice9::Reset()߂ODirect3DĂяo_炵B
	//܂IDirect3DDevice9::Reset()Ă񂾂Ƃ̓CxgnhDirect3D̊֐ĂԂȂĂƂȁB

	static HWND last_hWnd = 0;
	static gdxut* last_d3d = NULL;
//	static int cache_hit = 0, cache_miss = 0;

	gdxut* d3d;
	if(last_hWnd == hWnd)
	{
//		cache_hit++;
		d3d = last_d3d;
	}else
	{
//		cache_miss++;
		handle_map_itr i = handle_map.find(hWnd);

		if(i == handle_map.end())
		{
			return DefWindowProc(hWnd, message, wParam, lParam);
		}

	//	if(i == handle_map.end())
	//	{
	//		if(message == WM_DESTROY)
	//			PostQuitMessage(0);

	//		return DefWindowProc(hWnd, message, wParam, lParam);
	//	}

		d3d = i->second;
	}

	last_hWnd = hWnd;
	last_d3d = d3d;

	switch (message) 
	{
	case WM_CLOSE:
	{
//		TCHAR msg[256];

//		_stprintf(msg, _T("Hit=%d, miss=%d, rate=%f"), cache_hit, cache_miss, (double)cache_hit/(cache_miss+cache_hit));
//		MessageBox(NULL, msg, _T("info"), MB_OK);
	}break;

	default:
		break;
	}

	return d3d->wnd_proc(hWnd, message, wParam, lParam);
}

gdxut::gdxut():
	D3D(NULL), D3DDevice(NULL), hWnd(NULL),
	isLostDevice(true), isFullscreen(false), on_resetting(false)
{
	ZeroMemory(	&this->D3DPresentParam,	sizeof(D3DPRESENT_PARAMETERS) );

	ZeroMemory(this->clear_color, sizeof(int[3]));
}

gdxut::~gdxut()
{
	assert
	((
		"You have not to call destructor of gpuppur::gglut in callback function.",
		!this->getIsUninitializing()
	));

	this->uninitialize();
}

void gdxut::handle_event()
{
	MSG  msg;

	while(PeekMessage(&msg, NULL, 0U, 0U, PM_REMOVE) != 0)
	{
		if(msg.message == WM_QUIT)
		{

		}

		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	///Ƃꂼ̃EBhEWM_CLOSEAK؂ɏĂ͂B

	return/* ret*/;
}

void gdxut::uninitialize()
{
	if(!::handle_map.empty() && ::handle_map.find(this->hWnd) != ::handle_map.end())
		::handle_map.erase(this->hWnd);

	if(this->D3DDevice != NULL)
	{
		this->on_lost_device();
	}

	SAFE_RELEASE(this->D3DDevice);
	SAFE_RELEASE(this->D3D);

	if(!this->isClosed)
	{
		DestroyWindow(this->hWnd);
	}

	this->isClosed = true;
	this->hWnd = NULL;
	this->isLostDevice = true;
	this->isFullscreen = false;
	this->on_resetting = false;

	ZeroMemory(	&this->D3DPresentParam,	sizeof(D3DPRESENT_PARAMETERS) );
	ZeroMemory( &this->WindowRect, sizeof(RECT));
}

gpuppurut::ReturnCode gdxut::set_window( HWND hWndFocus )
{
	if( hWndFocus == NULL )
		return gpuppurut::ReturnCode::InvalidCall;

	this->hWnd = hWndFocus;

	RECT rect;
	GetClientRect( hWndFocus, &rect );
	this->WindowRect = rect;
	int width = rect.right - rect.left;
	int height = rect.bottom - rect.top;

	gpuppurut::ReturnCode	retCode =
								this->create_device(width, height);

	if(retCode == gpuppurut::ReturnCode::OK)
	{
		this->isClosed = false;
	}else
	{
		this->uninitialize();
	}

	return retCode;
}

LRESULT gdxut::wnd_proc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	if(this->on_resetting)
	{
		return DefWindowProc(hWnd, uMsg, wParam, lParam);
	}

	switch( uMsg )
    {
	case WM_ACTIVATEAPP:
	//	if(this->get_is_fullscreen())
	//	{
	//		VSIDEPrint(string("active_app in full\n"));
	//	}
		break;

	case WM_SIZE:
		if( SIZE_MAXIMIZED == wParam || SIZE_RESTORED == wParam )
			this->check_window_size_change();
		break;
	case WM_EXITSIZEMOVE:
		this->check_window_size_change();
		break;


	case WM_CLOSE:	//window悤ƂĂB
		//DefWindowProcWM_CLOSEȂΕȂB

		//windowOɎׂĉ
		this->uninitialize();
		break;
	case WM_DESTROY:
		//windowꂽB
	//	PostQuitMessage(0);
		this->isClosed = true;
		break;

	case WM_SYSKEYDOWN:
	case WM_KEYDOWN:
	case WM_SYSKEYUP:
	case WM_KEYUP:
		{
			int keypress = -1;

			POINT mouse_pos;

			GetCursorPos( &mouse_pos );
			ScreenToClient( hWnd, &mouse_pos );

	#		define KEY(a,b) case a: keypress = gpuppurut::##b; break;
			switch( wParam )
			{
				KEY( VK_F1,     F1        );
				KEY( VK_F2,     F2        );
				KEY( VK_F3,     F3        );
				KEY( VK_F4,     F4        );
				KEY( VK_F5,     F5        );
				KEY( VK_F6,     F6        );
				KEY( VK_F7,     F7        );
				KEY( VK_F8,     F8        );
				KEY( VK_F9,     F9        );
				KEY( VK_F10,    F10       );
				KEY( VK_F11,    F11       );
				KEY( VK_F12,    F12       );
				KEY( VK_PRIOR,  PAGE_UP   );
				KEY( VK_NEXT,   PAGE_DOWN );
				KEY( VK_HOME,   HOME      );
				KEY( VK_END,    END       );
				KEY( VK_LEFT,   LEFT      );
				KEY( VK_UP,     UP        );
				KEY( VK_RIGHT,  RIGHT     );
				KEY( VK_DOWN,   DOWN      );
				KEY( VK_INSERT, INSERT    );

			  case VK_DELETE:
				  /* The delete key is ASCII DEL. */
				  keypress = 127;
				  break;

			default:
				{
					BYTE state[ 256 ];
					WORD code[ 2 ];

					GetKeyboardState( state );

					if( ToAscii( static_cast<UINT>(wParam), 0, state, code, 0 ) == 1 )
						wParam=code[ 0 ];

					keypress = (char)wParam;
				}
			}
	#		undef KEY

			if(keypress != -1)
			{
				switch(uMsg)
				{
				case WM_SYSKEYDOWN:
				case WM_KEYDOWN:
					this->keyPressingFunc(*this, keypress, mouse_pos.x, mouse_pos.y);
					break;

				case WM_SYSKEYUP:
				case WM_KEYUP:
					this->keyUpFunc(*this, keypress, mouse_pos.x, mouse_pos.y);
					break;
				}
			}
		}
		break;

	case WM_MOUSEMOVE:
	case WM_LBUTTONDOWN:
	case WM_MBUTTONDOWN:
	case WM_RBUTTONDOWN:
	case WM_LBUTTONUP:
	case WM_MBUTTONUP:
	case WM_RBUTTONUP:
		{
			int button = gpuppurut::NONE;
			int state = gpuppurut::NONE;

			switch(uMsg)
			{
			case WM_LBUTTONDOWN:
			case WM_MBUTTONDOWN:
			case WM_RBUTTONDOWN:
				state = gpuppurut::KEY_DOWN;
				SetCapture(this->get_hWnd());
				break;
			case WM_LBUTTONUP:
			case WM_MBUTTONUP:
			case WM_RBUTTONUP:
				state = gpuppurut::KEY_UP;
				ReleaseCapture();
				break;
			}

			switch(uMsg)
			{
			case WM_LBUTTONDOWN:
			case WM_LBUTTONUP:
				button = gpuppurut::MOUSE_LEFT;
				break;
			case WM_MBUTTONDOWN:
			case WM_MBUTTONUP:
				button = gpuppurut::MOUSE_MIDDLE;
				break;
			case WM_RBUTTONUP:
			case WM_RBUTTONDOWN:
				button = gpuppurut::MOUSE_RIGHT;
				break;
			}

			int x = GET_X_LPARAM( lParam );
			int y = GET_Y_LPARAM( lParam );

			this->mouseFunc(*this, button, state, x, y);
		}
		break;

	default:
		break;
	}

	LRESULT ret = DefWindowProc(hWnd, uMsg, wParam, lParam);

	// ̕ǂ񂾐l͉̂WM_PAINTCxgĂ̂낤ƕsvcɎvƂ낤B
	// Lget_is_visiblełLost DevicêƂIDirect3DDevice9->Reset()ĂԂ悤ɂȂĂB
	// ɂDefWindowProc()֐̑OIDirect3DDevice9->Reset()ĂłResetȂ̂B
	// AłResetȂƂ͂邪EEE
	switch(uMsg)
	{
	case WM_PAINT:
		if(this->get_is_visible() == gpuppurut::ReturnCode::Visible)
		{
		//	if(this->get_is_fullscreen())
		//	{
		//		VSIDEPrint("redraw in full\n");
		//	}

			this->redraw();
		}
		break;
	}

	return ret;
}

bool gdxut::begin_scene(bool is_clear)
{
	if(this->isLostDevice)
		return false;

	B_RET( this->D3DDevice->BeginScene() );

	if(is_clear)
	{
		B_RET( this->D3DDevice->Clear(0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,
										D3DCOLOR_ARGB(0, this->clear_color[0], this->clear_color[1], this->clear_color[2]), 1.0f, 0) );
	}

	return true;
}

gpuppurut::ReturnCode gdxut::end_scene()
{
	if(this->isLostDevice)
		return gdxut::ReturnCode::Invisible;

	HRESULT ret = this->D3DDevice->EndScene();

	if( ret != D3D_OK)
	{
		if(ret == D3DERR_INVALIDCALL)
		{
			return gdxut::ReturnCode::InvalidCall;
		}else
		{
			return gdxut::ReturnCode::UnknownErr;
		}
	}

	ret = this->D3DDevice->Present( NULL, NULL, NULL, NULL );

	if(ret == D3DERR_DEVICELOST)
	{
		V( this->on_lost_device() );

		return gdxut::ReturnCode::Invisible;
	}else if(ret != D3D_OK)
	{
		TRACE_ERR("Failed to this->D3DDevice->Present( NULL, NULL, NULL, NULL );", ret);
	}

	if(IsIconic(this->hWnd) == TRUE)
	{
		return gdxut::ReturnCode::Invisible;
	}

	return gdxut::ReturnCode::OK;
}

void gdxut::redraw()
{
	this->redrawFunc(*this);
}

bool gdxut::set_fullscreen(bool is_full)
{
	if(is_full == this->isFullscreen)
	{
		return true;
	}

	int width = -1, height = -1;

	if(is_full)
	{
		RECT rect;
		GetWindowRect( this->hWnd, &rect );
		this->old_x = rect.left;
		this->old_y = rect.top;
		this->old_w = rect.right - rect.left;
		this->old_h = rect.bottom - rect.top;
	}else
	{
		width = to_client_width(this->old_w);
		height = to_client_height(this->old_h);
	}

	if(!this->set_default_present_param(is_full, D3DADAPTER_DEFAULT, width, height))
	{
		return false;
	}

	this->isFullscreen = is_full;
	this->D3DPresentParam.Windowed = is_full ? FALSE : TRUE;

	B_RET(this->reset(false));

	if(!is_full)
	{

		SetWindowPos(this->hWnd, HWND_NOTOPMOST, this->old_x, this->old_y, this->old_w, this->old_h,
    					SWP_NOACTIVATE | SWP_NOOWNERZORDER);

		// TCYmFR[h
	//	VSIDEPrint(string("left %d, right %d, top %d, bottom %d", this->WindowRect.left, this->WindowRect.right, this->WindowRect.top, this->WindowRect.bottom));
	}else
	{
		this->WindowRect.left = this->WindowRect.top = 0;
		this->WindowRect.right = this->D3DPresentParam.BackBufferWidth;
		this->WindowRect.bottom = this->D3DPresentParam.BackBufferHeight;

		// It seems no WM_SIZE message is send to window after changed to fullscreen mode. 
		B_RET(this->handle_window_size_change(this->D3DPresentParam.BackBufferWidth, this->D3DPresentParam.BackBufferHeight, false));
	}

	return true;
}

gpuppurut::ReturnCode gdxut::get_is_visible() const
{
	if(this->isClosed)
	{
		return gdxut::ReturnCode::Invisible;
	}

	if(this->D3DDevice == NULL)
	{
		return gdxut::ReturnCode::NotInitialized;
	}

	HRESULT ret = this->D3DDevice->TestCooperativeLevel();

	switch(ret)
	{
	case D3D_OK:
		if(this->get_is_fullscreen())
		{
			return gdxut::ReturnCode::Visible;
		}

		if(IsIconic(this->hWnd) == TRUE)
		{
			return gdxut::ReturnCode::Invisible;
		}

		return gdxut::ReturnCode::Visible;
	case D3DERR_DEVICELOST:
		const_cast<gdxut*>(this)->on_lost_device();
		return gdxut::ReturnCode::Invisible;
	case D3DERR_DEVICENOTRESET:
		ret = const_cast<gdxut*>(this)->reset();
		if(FAILED(ret) == TRUE)
		{
			return gdxut::ReturnCode::UnknownErr;
		}else
		{
			return gdxut::ReturnCode::Visible;
		}
	case D3DERR_DRIVERINTERNALERROR:
		return gdxut::ReturnCode::UnknownErr;
	default:
		return gdxut::ReturnCode::UnknownErr;
	}
}

bool gdxut::create_dx_Window(const std::string& title, int width, int height)
{
	WNDCLASSEXA wcex;
	static const char* class_name = "Direct3D library window with UNICODE";

	HINSTANCE hinst = GetModuleHandle(NULL);

	static ATOM atom = 0;

	if(atom == 0)
	{
		setWndClass(&wcex, class_name, hinst);

		if((atom = RegisterClassExA(&wcex)) == 0)
		{
			return false;
		}
	}

	width = to_window_width(width);
	height = to_window_height(height);

	HWND hWnd = CreateWindowA(class_name, title.c_str(), WS_OVERLAPPEDWINDOW,
							CW_USEDEFAULT, CW_USEDEFAULT, width, height, NULL, NULL, hinst,	NULL);

	return this->set_hWnd(hWnd);
}

bool gdxut::create_dx_Window(const std::wstring& title, int width, int height)
{
	WNDCLASSEXW wcex;
	static const wchar_t* class_name = L"Direct3D library window";

	HINSTANCE hinst = GetModuleHandle(NULL);

	static ATOM atom = 0;

	if(atom == 0)
	{
		setWndClass(&wcex, class_name, hinst);

		if((atom = RegisterClassExW(&wcex)) == 0)
		{
			return false;
		}
	}

	width = to_window_width(width);
	height = to_window_height(height);

	HWND hWnd = CreateWindowW(class_name, title.c_str(), WS_OVERLAPPEDWINDOW,
							CW_USEDEFAULT, CW_USEDEFAULT, width, height, NULL, NULL, hinst,	NULL);

	return this->set_hWnd(hWnd);
}

gpuppurut::ReturnCode
	gdxut::create_device( int width, int height,
							bool is_full,	UINT AdapterOrdinal	)
{
	if(this->hWnd	== NULL)
	{
		return gpuppurut::ReturnCode::InvalidCall;
	}

	if(	NULL ==	( this->D3D = Direct3DCreate9(D3D_SDK_VERSION) ) )
	{
		return gpuppurut::ReturnCode::NORUNTIME;
	}

	if(	!D3DXCheckVersion(D3D_SDK_VERSION, D3DX_SDK_VERSION) )
	{
		return gpuppurut::ReturnCode::INCORRECTVERSION;
	}

	D3DCAPS9 caps;
	this->D3D->GetDeviceCaps(AdapterOrdinal, D3DDEVTYPE_HAL, &caps);

	DWORD behaviorFlags;

	if(	(caps.DevCaps &	D3DDEVCAPS_HWTRANSFORMANDLIGHT)	== 0 ||
		 caps.VertexShaderVersion <	D3DVS_VERSION(1,1) )
	{
		behaviorFlags =	D3DCREATE_SOFTWARE_VERTEXPROCESSING;
	}
	else
	{
		behaviorFlags =	D3DCREATE_HARDWARE_VERTEXPROCESSING;
	}

	if ((caps.DevCaps &	D3DDEVCAPS_PUREDEVICE) != 0	&& 
		(behaviorFlags & D3DCREATE_HARDWARE_VERTEXPROCESSING) != 0 )
		behaviorFlags |= D3DCREATE_PUREDEVICE;

	if(!this->set_default_present_param(is_full, D3DADAPTER_DEFAULT, width, height))
	{
		return gpuppurut::ReturnCode::CREATING3DDEVICE;
	}

	D3DPRESENT_PARAMETERS dm = this->D3DPresentParam;

	T_RET(this->D3D->CreateDevice( AdapterOrdinal,	D3DDEVTYPE_HAL,	this->hWnd,
								  behaviorFlags,
								  &dm,
								  &this->D3DDevice ),
		  gpuppurut::ReturnCode::CREATING3DDEVICE);

	this->isFullscreen = is_full;
	this->isClosed = false;


	T_RET(this->reset(), gpuppurut::ReturnCode::CREATING3DDEVICE);

	return gpuppurut::ReturnCode::OK;
}

bool gdxut::set_hWnd(HWND hWnd)
{
	if (!hWnd)
	{
		return false;
	}

	this->hWnd = hWnd;
	::handle_map[hWnd] = this;

	ShowWindow(hWnd, SW_SHOWNA);
	UpdateWindow(hWnd);

	return true;
}

void gdxut::check_window_size_change()
{
	if(this->D3DDevice == NULL)
		return;

	RECT rect;
	GetClientRect( this->hWnd, &rect );
	int width = rect.right - rect.left;
	int height = rect.bottom - rect.top;

	if( width == this->WindowRect.right - this->WindowRect.left
		&& height == this->WindowRect.bottom - this->WindowRect.top)
	{
		return;
	}

	if(rect.left == rect.right || rect.top == rect.bottom)
	{
		return;
	}

	if(this->get_is_visible() != gpuppurut::ReturnCode::Visible)
	{
		return;
	}

	this->WindowRect = rect;

	V(this->handle_window_size_change(width, height));
}

HRESULT gdxut::handle_window_size_change(int width, int height, bool need_reset)
{
	this->D3DPresentParam.BackBufferWidth = width;
	this->D3DPresentParam.BackBufferHeight = height;

	if(need_reset)
	{
		V_RET(this->reset(false));
	}

	this->resizeFunc(*this, width, height);
	this->redraw();

	return S_OK;
}

HRESULT gdxut::reset(bool needed_resize_and_redraw)
{
	assert(this->D3D != NULL);
	assert(this->D3DDevice != NULL);

	if(!this->isLostDevice)
	{
		V_RET(this->on_lost_device());
	}

	D3DPRESENT_PARAMETERS d3dpp = this->D3DPresentParam;

	this->on_resetting = true;
	V_RET(this->D3DDevice->Reset(&d3dpp));
	this->on_resetting = false;

	if(!this->init3DContextFunc(*this))
	{
		this->is_user_init_failed = true;
		return E_FAIL;
	}

	this->isLostDevice = false;

	if(needed_resize_and_redraw)
	{
		this->handle_window_size_change(d3dpp.BackBufferWidth, d3dpp.BackBufferHeight, false);
	}

	return S_OK;
}


/// sfalseԂB
bool gdxut::set_default_present_param(bool is_full, UINT adapter, int width, int height)
{
	assert(this->D3D != NULL);

	HRESULT hr;
	D3DFORMAT backBufferFormat = D3DFMT_UNKNOWN;
	UINT refreshRate = 0;

	if(is_full)
	{
		//K؂BackBufferformat𒲂ׂB
		//ł邾rbg傫̗̂pB
		D3DFORMAT adapterFormat = D3DFMT_UNKNOWN;
		static const D3DFORMAT testFormats[][2] = {
													{D3DFMT_X8R8G8B8, D3DFMT_A8R8G8B8},
													{D3DFMT_X1R5G5B5, D3DFMT_A1R5G5B5},
													{D3DFMT_R5G6B5, D3DFMT_R5G6B5}};

		for(std::size_t i=0; i<sizeof(testFormats)/(sizeof(D3DFORMAT)*2); i++)
		{
			hr = this->D3D->CheckDeviceType(adapter, D3DDEVTYPE_HAL, testFormats[i][0], testFormats[i][1], FALSE);
			assert(hr != D3DERR_INVALIDCALL);

			if(hr == D3DERR_NOTAVAILABLE)
			{
				continue;
			}

			backBufferFormat = testFormats[i][1];
			adapterFormat = testFormats[i][0];
			break;
		}

		if(backBufferFormat == D3DFMT_UNKNOWN)
		{
			MessageBox(NULL, _T("No available Buffer format"), _T("err"), MB_OK);
			return false;
		}

		//XN[TCYw肳ĂȂꍇÃ݂fXNgbṽTCY𒲂ׁA
		//̃TCYtXN[̃TCYɂB
		if(width == -1 || height == -1)
		{
			D3DDISPLAYMODE dm;
			hr = this->D3D->GetAdapterDisplayMode(adapter, &dm);
			assert(hr == D3D_OK);

			width = dm.Width;
			height = dm.Height;
		}

		/// K؂Display mode𒲂ׂāAK؂refresh rate𓾂B
		UINT amc = this->D3D->GetAdapterModeCount(adapter, adapterFormat);
		if(amc == 0)
		{
			return false;
		}

		UINT i;
		for(i=0; i<amc; i++)
		{
			D3DDISPLAYMODE dm;
			hr = this->D3D->EnumAdapterModes(adapter, adapterFormat, i, &dm);

			assert(hr != D3DERR_INVALIDCALL);

			if(hr == D3DERR_NOTAVAILABLE)
			{
				continue;
			}

			if(dm.Width	== static_cast<UINT>(width) &&	dm.Height == static_cast<UINT>(height))
			{
				refreshRate = dm.RefreshRate;
				break;
			}
		}

		if(i == amc)
		{
			return false;
		}
	}else
	{
		if(width == -1 || height == -1)
		{
			width = 640;
			height = 480;
			if(!SetWindowPos(this->hWnd, HWND_NOTOPMOST, 0, 0, width, height, SWP_SHOWWINDOW))
				return false;
		}
	}

	ZeroMemory(	&this->D3DPresentParam,	sizeof(D3DPRESENT_PARAMETERS) );
	this->D3DPresentParam.BackBufferWidth				= width;
	this->D3DPresentParam.BackBufferHeight				= height;
	this->D3DPresentParam.BackBufferFormat				= backBufferFormat;
//	this->D3DPresentParam.BackBufferCount				= 1;
	this->D3DPresentParam.SwapEffect					= D3DSWAPEFFECT_DISCARD;
	this->D3DPresentParam.hDeviceWindow					= this->hWnd;
	this->D3DPresentParam.Windowed						= is_full ? FALSE : TRUE;
	this->D3DPresentParam.EnableAutoDepthStencil		= TRUE;
	this->D3DPresentParam.AutoDepthStencilFormat		= D3DFMT_D16;
	this->D3DPresentParam.Flags							= D3DPRESENTFLAG_DISCARD_DEPTHSTENCIL;
	this->D3DPresentParam.FullScreen_RefreshRateInHz	= refreshRate;
	this->D3DPresentParam.PresentationInterval			= D3DPRESENT_INTERVAL_IMMEDIATE;

	return true;
}

HRESULT gdxut::on_lost_device()
{
	assert(this->D3D != NULL);
	assert(this->D3DDevice != NULL);

	if(this->isLostDevice)
		return S_OK;

	this->isLostDevice = true;

	this->uninit3DContext();

	return S_OK;
}
