#include "stdafx.h"
#include <stdio.h>
#include <iostream>
#include <boost/random.hpp>
#include <boost/bind.hpp>
#include <D3dx9shape.h>
#include <d3dx9math.h>
#include <boost/ptr_container/ptr_list.hpp>
#include <memory>
#include <vector>

#ifndef LIBRARY

using namespace gpuppur;
using namespace boost;
using namespace std;

bool	bRun = true;
gdxut	gGut;

class Drawer
{
public:

	Drawer():teapot(NULL), rot(0.0f), pressed_left(false), pressed_right(false),
		begin_pos(0.0f, 0.0f), current_pos(0.0f, 0.0f),
		begin_rot(0.0f, 0.0f), current_rot(0.0f, 0.0f),
		begin_mouse_x(0), begin_mouse_y(0)
	{
	}

	void resize(gpuppurut& direct3d, int width, int height)
	{
		this->rot += 3.141f/4.0f;

		gdxut& d3d = static_cast<gdxut&>(direct3d);
		D3DXMATRIX mat;

		D3DXMatrixPerspectiveFovLH(&mat, 3.14f/4.0f, (float)width/height, 1.0f, 100.0f);
		d3d.get_device()->SetTransform(D3DTS_PROJECTION, &mat);

		D3DVIEWPORT9 vp = {0, 0, width, height, 0.0f, 1.0f};
		d3d.get_device()->SetViewport(&vp);
	}

	void on_lost_device(gpuppurut&)
	{
		SAFE_RELEASE(this->teapot);
	}

	void on_reset_device(gpuppurut& direct3d)
	{
		gdxut& d3d = static_cast<gdxut&>(direct3d);

		d3d.get_device()->LightEnable(0, TRUE);
		d3d.get_device()->SetFVF(D3DFVF_XYZ | D3DFVF_NORMAL);
		D3DLIGHT9 light;
		ZeroMemory(&light, sizeof(light));
		light.Type = D3DLIGHT_DIRECTIONAL;
		light.Diffuse.r = 0.0f;
		light.Diffuse.g = 1.0f;
		light.Diffuse.b = 0.0f;
		D3DCOLORVALUE ambient = {0.2f, 0.2f, 0.2f, 1.0f};
		light.Ambient = ambient;
		light.Direction = D3DXVECTOR3(0.2f, -0.4f, 0.6f);

		d3d.get_device()->SetLight(0, &light);

		D3DMATERIAL9 material = {
			{1.0f, 1.0f, 1.0f, 1.0f},	//diffuse
			{0.2f, 0.2f, 0.2f, 1.0f},	//ambient
			{0.0f, 0.0f, 0.0f, 1.0f},	//specular
			{0.2f, 0.2f, 0.2f, 1.0f}	//emissive
		};
		d3d.get_device()->SetMaterial(&material);

		LPD3DXMESH tmp;
		LPD3DXBUFFER padj;
		V(D3DXCreateTeapot(d3d.get_device(), &tmp, &padj));
		V(tmp->Optimize(D3DXMESHOPT_ATTRSORT, (const DWORD*)padj->GetBufferPointer(), NULL, NULL, NULL, &this->teapot));
		SAFE_RELEASE(tmp);
		SAFE_RELEASE(padj);

		d3d.set_clear_color(50, 90, 60);
		D3DXMatrixTranslation(&this->mat, this->current_pos.x, this->current_pos.y, 5.0f);
	}

	void redraw(gpuppurut& direct3d)
	{
		gdxut& d3d = static_cast<gdxut&>(direct3d);

		if(d3d.get_is_visible() != gpuppurut::ReturnCode::Visible)
			return;

		D3DXMATRIX rot_mat, tmp_mat;
		D3DXMatrixRotationYawPitchRoll(&rot_mat, this->current_rot.x, this->current_rot.y, this->rot);

		d3d.get_device()->SetTransform(D3DTS_WORLDMATRIX(0), D3DXMatrixMultiply(&tmp_mat, &rot_mat, &this->mat));

		DWORD num_attr = 999;

		V(this->teapot->GetAttributeTable(NULL, &num_attr));

		vector<D3DXATTRIBUTERANGE> attr_table(num_attr);
		V(this->teapot->GetAttributeTable(&attr_table[0], &num_attr));

		if(d3d.begin_scene(false))
		{
			D3DRECT r = {0, 0, d3d.get_width()/2, d3d.get_height()/2};
			V( d3d.get_device()->Clear(1, &r, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,
										D3DCOLOR_ARGB(255, 255, 255, 255), 1.0f, 0) );

			D3DRECT r1 = {d3d.get_width()/2, 0, d3d.get_width(), d3d.get_height()/2};
			V( d3d.get_device()->Clear(1, &r1, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,
										D3DCOLOR_ARGB(255, 0, 255, 255), 0.8f, 0) );

			D3DRECT r2 = {0, d3d.get_height()/2, d3d.get_width()/2, d3d.get_height()};
			V( d3d.get_device()->Clear(1, &r2, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,
										D3DCOLOR_ARGB(255, 255, 0, 255), 0.8f, 0) );

			D3DRECT r3 = {d3d.get_width()/2, d3d.get_height()/2, d3d.get_width(), d3d.get_height()};
			V( d3d.get_device()->Clear(1, &r3, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,
										D3DCOLOR_ARGB(255, 255, 255, 0), 1.0f, 0) );

			V(this->teapot->DrawSubset(attr_table[0].AttribId));
			d3d.end_scene();
		}
	}

	void keyUp(gpuppurut& gpuppur, int key, int mouse_x, int mouse_y)
	{
		gdxut& d3d = static_cast<gdxut&>(gpuppur);

		if(key == gpuppurut::F1)
		{
			d3d.set_fullscreen(!d3d.get_is_fullscreen());
		}else if(key == '\x1b')
		{
			d3d.uninitialize();
		}else if(key == 'g')
		{
			float x = (float)mouse_x/d3d.get_width();
			float y = (float)mouse_y/d3d.get_height();

			x = x*2.0f - 1.0f;
			y = y*2.0f - 1.0f;
			D3DXMatrixTranslation(&this->mat, x*2.0f, y*-2.0f, 5.0f);
			d3d.redraw();
		}else if(key == 'Q')
		{
			bRun = false;
		}
	}

	void mouse(gpuppurut& gpuppurut, int button, int state, int x, int y)
	{
		gdxut& d3d = static_cast<gdxut&>(gpuppurut);

		if(state == gpuppurut::NONE && !this->pressed_left && !this->pressed_right)
		{
			return;
		}

		if(button == gpuppurut::NONE)
		{
			if(this->pressed_left)
			{
				this->current_pos = D3DXVECTOR2(static_cast<float>(x), static_cast<float>(-y))
								  - D3DXVECTOR2(static_cast<float>(this->begin_mouse_x), static_cast<float>(-begin_mouse_y));
				this->current_pos = current_pos / 600.0f + begin_pos;
				D3DXMatrixTranslation(&this->mat, this->current_pos.x, this->current_pos.y, 5.0f);
			}

			if(this->pressed_right)
			{
				this->current_rot = D3DXVECTOR2(static_cast<float>(x), static_cast<float>(-y))
								  - D3DXVECTOR2(static_cast<float>(this->begin_mouse_x), static_cast<float>(-begin_mouse_y));
				this->current_rot = this->current_rot / 600.0f + this->begin_rot;
			}

			return this->redraw(d3d);
		}

		if(button == gpuppurut::MOUSE_LEFT)
		{
			this->pressed_left = state == gpuppurut::KEY_DOWN;
			begin_pos = current_pos;
		}else if(button == gpuppurut::MOUSE_RIGHT)
		{
			this->pressed_right = state == gpuppurut::KEY_DOWN;
			begin_rot= current_rot;
		}

		begin_mouse_x = x;
		begin_mouse_y = y;
	}

private:
	D3DXMATRIX	mat;
	ID3DXMesh*	teapot;
	float		rot;
	bool		pressed_left;
	bool		pressed_right;
	D3DXVECTOR2	begin_pos;
	D3DXVECTOR2	current_pos;
	D3DXVECTOR2 begin_rot;
	D3DXVECTOR2	current_rot;
	int			begin_mouse_x;
	int			begin_mouse_y;
};

class windows
{
public:
	class my_gdxut : public gdxut
	{
	public:
		ptr_list<gdxut>::iterator	me;
		bool						is_anim;
		bool						deleted;

		my_gdxut():is_anim(true), deleted(false)
		{
		}

		virtual ~my_gdxut()
		{
		}
	};

	class draw_gdxut : public my_gdxut
	{
	public:
		Drawer drawer;

		draw_gdxut()
		{
			is_anim = false;
		}
	};

	windows():
	dst(0, 400), rand(gen, dst)
	{
	}

	bool add()
	{
		int rndm = rand()&1;

		my_gdxut* tmp_ptr;

		if(rndm==1)
		{
			my_gdxut* p = new my_gdxut();
			p->setUninit3DContextFunc(&windows::on_lost_device);
			p->setInit3DContextFunc(&windows::on_reset_device);
			p->setResizeFunc(&windows::resize);
			p->setKeyUpFunc(bind(&windows::key_up, this, _1, _2, _3, 4));

			tmp_ptr = p;
		}else
		{
			draw_gdxut* p = new draw_gdxut;
			p->setUninit3DContextFunc(bind(&Drawer::on_lost_device, &p->drawer, _1));
			p->setInit3DContextFunc(bind(&Drawer::on_reset_device, &p->drawer, _1));
			p->setResizeFunc(bind(&Drawer::resize, &p->drawer, _1, _2, _3));
			p->setRedrawFunc(bind(&Drawer::redraw, &p->drawer, _1));
			p->setKeyUpFunc(bind(&Drawer::keyUp, &p->drawer, _1, _2, _3, _4));
			p->setMouseFunc(bind(&Drawer::mouse, &p->drawer, _1, _2, _3, _4, _5));

			tmp_ptr = p;
		}

		auto_ptr<my_gdxut> p(tmp_ptr);

		gpuppurut::ReturnCode ret = ((rand()&1)==1) ?
			p->initialize(700, 100, std::wstring(L"{ǁ[eeeH\exarh")) :
		p->initialize(100, 700, std::string("nne\gałĂkai?"));	//Unicodeg悤ɐݒ肵ꍇAstd::stringchar*͕̕܂B

		if( ret != 
			gpuppurut::ReturnCode::OK)
		{
			if(ret == gpuppurut::ReturnCode::CREATING3DDEVICE)
			{
				return false;
			}

			return false;
		}

		gdxuts.push_front(p.release());
		gdxuts.front().me = gdxuts.begin();

		return true;
	}

	void process()
	{
		static float obj[][3] = {{-0.5, -0.5, 1.0}, {0.5, 0.5, 1.0}, {0.5, -0.5, 1.0}};
		static float rot = 0.0f;
		obj[0][0] = 0.5f*sin(rot);
		rot += 0.01f;

		bRun = false;
		gdxut_list_itr i;

		for(i=gdxuts.begin(); i!= gdxuts.end();)
		{
			if(i->deleted)
			{
				gdxuts.erase(i++);
			}else
			{
				++i;
			}
		}

		for(i=gdxuts.begin(); i!= gdxuts.end(); ++i)
		{
			bRun = !i->get_is_closed() || bRun;

			if(i->get_is_closed())
			{
				if(rand() == 2)
				{
					i->initialize(300, 400, std::wstring(L""));
				}else
				{
					continue;
				}
			}

			if(!i->is_anim)
			{
				continue;
			}

			gpuppurut::ReturnCode ret = i->get_is_visible();

			if(ret == gpuppurut::ReturnCode::Invisible)
			{
				continue;
			}else if(ret != gpuppurut::ReturnCode::Visible)
			{
				MessageBox(NULL, _T("Unknown Err!"), _T("err"), MB_OK);
				i->uninitialize();
				break;
			}

			if(i->begin_scene())
			{
				i->get_device()->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP, 1, obj, sizeof(float)*3);

				ret = i->end_scene();

				switch(ret)
				{
				case gdxut::ReturnCode::OK:
					break;

				case gpuppurut::ReturnCode::Invisible:
					break;

				case gpuppurut::ReturnCode::UnknownErr:
					MessageBox(NULL, _T("Unknown Err!"), _T("err"), MB_OK);
					break;

				case gpuppurut::ReturnCode::InvalidCall:
					MessageBox(NULL, _T("Invalid Call! to gdxut.end_scene();"), _T("err"), MB_OK);
					break;

				default:
					assert(false);
					break;
				}
			}else
			{
				MessageBox(NULL, _T("Failed to begin_scene!"), _T("ERR"), MB_OK);
				break;
			}
		}
	}

	static void on_lost_device(gpuppurut&)
	{
		return;
	}

	static void on_reset_device(gpuppurut& direct3d)
	{
		gdxut& d3d = static_cast<gdxut&>(direct3d);

		d3d.get_device()->SetFVF(D3DFVF_XYZ);
		d3d.get_device()->SetRenderState(D3DRS_LIGHTING, FALSE);
	}

	static void resize(gpuppurut& direct3d, int width, int height)
	{
		gdxut& d3d = static_cast<gdxut&>(direct3d);
		D3DXMATRIX mat;

		D3DXMatrixOrthoRH(&mat, width/50.0f, height/50.0f, 0, -100);
		d3d.get_device()->SetTransform(D3DTS_PROJECTION, &mat);

		D3DVIEWPORT9 vp = {0, 0, width, height, 0.0f, 1.0f};
		d3d.get_device()->SetViewport(&vp);
	}

	void key_up(gpuppurut& gpuppur, int key, int, int)
	{
		my_gdxut& gut = static_cast<my_gdxut&>(gpuppur);

		if(key == gpuppurut::F1)
		{
			gut.set_fullscreen(!gut.get_is_fullscreen());
		}else if(key == '\x1b')
		{
			gut.uninitialize();
		}else if(key == 'Q')
		{
			bRun = false;
		}else if(key == 'd')
		{
			gut.deleted = true;
		}else if(key == 'a')
		{
			this->add();
		}
	}

private:
	ptr_list<my_gdxut>						gdxuts;
	typedef ptr_list<my_gdxut>::iterator	gdxut_list_itr;

	boost::mt19937			gen;
	boost::uniform_int<>	dst;
	boost::variate_generator<boost::mt19937, boost::uniform_int<> >
							rand;
};

HINSTANCE hInst;

ATOM				MyRegisterClass(HINSTANCE hInstance);
bool				createWindow(HINSTANCE hInstance, int nCmdShow);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);

int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE /*hPrevInstance*/,
                     LPTSTR    /*lpCmdLine*/,
                     int       nCmdShow)
{
	gdxut::global_initialize();

	Drawer drawer;

	gGut.setUninit3DContextFunc(bind(&Drawer::on_lost_device, &drawer, _1));
	gGut.setInit3DContextFunc(bind(&Drawer::on_reset_device, &drawer, _1));
	gGut.setResizeFunc(bind(&Drawer::resize, &drawer, _1, _2, _3));
	gGut.setRedrawFunc(bind(&Drawer::redraw, &drawer, _1));
	gGut.setKeyUpFunc(bind(&Drawer::keyUp, &drawer, _1, _2, _3, _4));
	gGut.setMouseFunc(bind(&Drawer::mouse, &drawer, _1, _2, _3, _4, _5));

	MyRegisterClass(hInstance);
	if(!createWindow(hInstance, nCmdShow))
	{
		return 0;
	}

	windows wins;

	wins.add();

	while (bRun)
	{
		wins.process();

		Sleep(10);
		gdxut::handle_event();
	}

	gGut.uninitialize();

	return 0/*(int) msg.wParam*/;
}

TCHAR szWindowClass[] = _T("gdxut_test");

ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= NULL;
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= NULL;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= NULL;

	return RegisterClassEx(&wcex);
}

bool createWindow(HINSTANCE hInstance, int nCmdShow)
{
	HWND hWnd;

	hInst = hInstance;

	TCHAR szTitle[] = _T("set_windowgĂgdxut");


	hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
			CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

	if (!hWnd)
	{
		return false;
	}

	ShowWindow(hWnd, nCmdShow);
	gpuppurut::ReturnCode ret = gGut.set_window(hWnd);

	return ret == gpuppurut::ReturnCode::OK ? true : false;
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
//	PAINTSTRUCT ps;
//	HDC hdc;

	switch (message) 
	{
	case WM_COMMAND:
		break;
	case WM_PAINT:
	//	hdc = BeginPaint(hWnd, &ps);
	//	EndPaint(hWnd, &ps);
		break;
	case WM_DESTROY:
	//	PostQuitMessage(0);
		break;
	default:
		break;
	}

	return gGut.wnd_proc(hWnd, message, wParam, lParam);
}

#endif