#include "../gpuppurut/config.h"
#include "stdafx.h"

using namespace gpuppur;

bool	gglut::is_global_initialized = false;

gglut* gglut::getpGGLUT()
{
	assert(glutGetWindowData() != NULL);

	return reinterpret_cast<gglut*>(glutGetWindowData());
}

void gglut::close()
{
	gglut* const pglut = getpGGLUT();

	pglut->isClosed = true;
	pglut->windowID = -1;
	pglut->isVisible = false;
	pglut->uninit3DContext();
}

void gglut::display()
{
	gglut* const pglut = getpGGLUT();

	assert(pglut->windowID > 0);

	pglut->redrawFunc(*pglut);
}

void gglut::reshape(int width, int height)
{
	gglut* const pglut = getpGGLUT();

	pglut->resizeFunc(*pglut, width, height);
}

void gglut::windowStatus(int state)
{
	gglut* const pglut = getpGGLUT();

	pglut->isVisible = (state != GLUT_FULLY_COVERED);
}

void gglut::keybord(unsigned char key, int x, int y)
{
	gglut* const pglut = getpGGLUT();

	pglut->keyPressingFunc(*pglut, static_cast<int>(key), x, y);
}

void gglut::special(int key, int x, int y)
{
	gglut* const pglut = getpGGLUT();

	pglut->keyPressingFunc(*pglut, key+gglut::glutSpecialKeyOffset, x, y);
}

void gglut::keybordUp(unsigned char key, int x, int y)
{
	gglut* const pglut = getpGGLUT();

	pglut->keyUpFunc(*pglut, static_cast<int>(key), x, y);
}

void gglut::specialUp(int key, int x, int y)
{
	gglut* const pglut = getpGGLUT();

	pglut->keyUpFunc(*pglut, key+gglut::glutSpecialKeyOffset, x, y);
}

void gglut::motion(int x, int y)
{
	gglut* const pglut = getpGGLUT();

	pglut->mouseFunc(*pglut, gpuppurut::NONE, gpuppurut::NONE, x, y);
}

void gglut::mouse(int button, int state, int x, int y)
{
	gglut* const pglut = getpGGLUT();

	int button_map[] = {gpuppurut::MOUSE_LEFT, gpuppurut::MOUSE_MIDDLE, gpuppurut::MOUSE_RIGHT};
	int state_map[] = {gpuppurut::KEY_DOWN, gpuppurut::KEY_UP};

	pglut->mouseFunc(*pglut, button_map[button], state_map[state], x, y);
}

void gglut::passiveMotion(int x, int y)
{
	gglut* const pglut = getpGGLUT();

	pglut->mouseFunc(*pglut, gpuppurut::NONE, gpuppurut::NONE, x, y);
}

#ifdef _WIN32
#ifdef _WINDOWS
void gglut::global_initialize()
{
	LPTSTR c = GetCommandLine();
	int argc;

#ifdef UNICODE
	LPTSTR* ppArgvW = CommandLineToArgvW(c, &argc);

	gglut::global_initialize(&argc, ppArgvW);

	GlobalFree(ppArgvW);
#else
	//CommandLineToArgvW̔unicodełWin32APIɗpӂĂȂB͂Ŏ̂܂ǁi
	BOOST_STATIC_ASSERT("Please compile this program as unicode,"
					    "or begin from main function."
						==
						"unicodegĉBꂩmain֐vOJn悤ɂĉB");
#endif
}
#endif

#ifdef UNICODE
void gglut::global_initialize(int* pargc, TCHAR** argv)
{
	std::vector<char*> tmp_argv;
	std::vector<std::vector<char> > argv_area;

	for(int i=0; i<*pargc; i++)
	{
		std::size_t tmp_size = _tcslen(*(argv+i))+1;
		if(tmp_size > INT_MAX)
		{
			assert(("sorry, i cant parse tooooo long argv:p", false));
			// because value of tmp_size cant be represented in int type, and WideCharToMultiByte() function take int type argument.
		}

		int size = static_cast<int>(tmp_size);

		argv_area.push_back(std::vector<char>(size));
		WideCharToMultiByte(CP_ACP, 0, *(argv+i), -1, &argv_area.back()[0], size, NULL, NULL);
	}

	tmp_argv.resize(*pargc);
	for(int i=0; i<*pargc; i++)
	{
		tmp_argv[i] = &argv_area[i][0];
	}

	gglut::global_initialize(pargc, &tmp_argv[0]);
}
#endif	//end of #ifdef UNICODE
#endif	//end of #ifdef _WIN32

void gglut::global_initialize(int* pargc, char** argv)
{
	glutInit(pargc, &argv[0]);
	glutSetOption(GLUT_ACTION_ON_WINDOW_CLOSE, /*GLUT_ACTION_CONTINUE_EXECUTION*/ GLUT_ACTION_GLUTMAINLOOP_RETURNS);
//	glutSetOption(GLUT_RENDERING_CONTEXT, GLUT_USE_CURRENT_CONTEXT);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_DEPTH | GLUT_RGBA);

	gglut::is_global_initialized = true;
}

void gglut::handle_event()
{
	glutMainLoopEvent();
}

gpuppurut::ReturnCode gglut::init()
{
	glutSetWindowData(reinterpret_cast<void*>(this));
	glutDisplayFunc(&gglut::display);
	glutReshapeFunc(&gglut::reshape);
	glutCloseFunc(&gglut::close);
	glutWindowStatusFunc(&gglut::windowStatus);
	glutKeyboardFunc(&gglut::keybord);
	glutSpecialFunc(&gglut::special);
	glutKeyboardUpFunc(&gglut::keybordUp);
	glutSpecialUpFunc(&gglut::specialUp);
	glutMotionFunc(&gglut::motion);
	glutMouseFunc(&gglut::mouse);
	glutPassiveMotionFunc(&gglut::passiveMotion);

	this->isVisible = true;
	this->isClosed = false;

	if(this->init3DContextFunc(*this)==false)
	{
		return gpuppurut::ReturnCode::FailedUserInit;
	}

	return gpuppurut::ReturnCode::OK;
}

gglut::gglut():
	isFullscreen(false),
	isVisible(false),
	windowID(-1)
{
}

gglut::~gglut()
{
	assert
	((
		"You have not to call destructor of gpuppur::gglut in callback function.",
		!this->getIsUninitializing()
	));

	this->uninitialize();
}

void gglut::uninitialize()
{
	if(this->windowID != -1)
	{
		this->uninit3DContext();
		glutDestroyWindow(this->windowID);
	}

	this->windowID = -1;
	this->isClosed = true;
	this->isVisible = false;
	this->isFullscreen = false;
}

bool gglut::begin_scene(bool is_clear)
{
	if(this->isClosed)
	{
		return false;
	}

	glutSetWindow(this->windowID);

	if(is_clear)
	{
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	}

	return true;
}

gpuppurut::ReturnCode	gglut::end_scene()
{
	if(this->isClosed)
	{
		return false;
	}

	glutSwapBuffers();

	if(this->get_is_visible() == ReturnCode::Invisible)
	{
		return ReturnCode::Invisible;
	}

	return gpuppurut::ReturnCode::OK;
}

void gglut::redraw()
{
	this->redrawFunc(*this);
}

bool gglut::set_fullscreen(bool isFull)
{
	if(this->isFullscreen == isFull)
	{
		return true;
	}

	this->isFullscreen = !this->isFullscreen;

	glutSetWindow(this->windowID);

	if(isFull)
	{
		this->old_x = glutGet(GLUT_WINDOW_X);
		this->old_y = glutGet(GLUT_WINDOW_Y);
		this->old_w = glutGet(GLUT_WINDOW_WIDTH);
		this->old_h = glutGet(GLUT_WINDOW_HEIGHT);

		glutFullScreen();

		return true;
	}

	//In both freeglut and openglut, when reverse order of following functions, window size become size of display resolution.
	glutReshapeWindow(this->old_w, this->old_h);
	glutPositionWindow(this->old_x, this->old_y);

	return true;
}

int	gglut::get_width() const
{
	return glutGet(GLUT_WINDOW_WIDTH);
}

int	gglut::get_height() const
{
	return glutGet(GLUT_WINDOW_HEIGHT);
}

int	gglut::createWindow(int width, int height, const std::string& title)
{
	glutInitWindowSize(width, height);
	return glutCreateWindow(title.c_str());
}

int	gglut::createWindow(int width, int height, const std::wstring& title)
{
	std::vector<char> mbstr;

	gpuppur::to_char_from_wchar_t(mbstr, title.c_str());

	glutInitWindowSize(width, height);
	return glutCreateWindow(&mbstr[0]);
}