#include "stdafx.h"
#include <boost/random.hpp>
#include <boost/shared_ptr.hpp>
#include <vector>

using namespace gpuppur;

namespace
{

typedef boost::shared_ptr<gglut>	PGLUT;
typedef std::vector<PGLUT>			GLUTVec;
typedef GLUTVec::iterator			GLUTVecItr;

GLUTVec GLUTs;
boost::mt19937			gen;
boost::uniform_int<>	big_dst(0, 400);
boost::variate_generator<boost::mt19937, boost::uniform_int<> >
						big_rand(gen, big_dst);

boost::uniform_int<>	small_dst(1, 4);
boost::variate_generator<boost::mt19937, boost::uniform_int<> >
						small_rand(gen, small_dst);

gpuppurut::ReturnCode InitGLUT(gglut& glut);

int current_x = 0, current_y = 0, begin_x = 0, begin_y = 0, begin_mouse_x=0, begin_mouse_y=0;
bool pressed_left = false, pressed_right = false;

void Resize(gpuppurut&, int width, int height)
{
	glViewport(0, 0, width, height);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	GLdouble w = static_cast<GLdouble>(width) / 100.0;
	GLdouble h = static_cast<GLdouble>(height) / 100.0;

	glOrtho(-w, w, -h, h, 0.0, -100);

	glMatrixMode(GL_MODELVIEW);
}

void Resize2(gpuppurut&, int width, int height)
{
	glViewport(0, 0, width, height);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	glOrtho(-1, 1, -1, 1, 0.0, -100);

	glMatrixMode(GL_MODELVIEW);
}

void OnInitDevice(gpuppurut&)
{
	glClearColor(0.1f, 0.6f, 0.2f, 1.0f);
}

void KeyUp(gpuppurut& gpuppurut, int key, int, int)
{
	gglut& glut = static_cast<gglut&>(gpuppurut);

	if(key == gglut::F1)
	{
		glut.set_fullscreen(true);
	}else if(key == gglut::F2)
	{
		glut.set_fullscreen(false);
	}else if(key == '\x1b') //esc key
	{
		glut.uninitialize();
	}else if(key == 'a')
	{
		GLUTVecItr i = GLUTs.begin();

		for(; i != GLUTs.end(); ++i)
		{
			if((**i).get_is_closed())
			{
				break;
			}
		}

		if(i == GLUTs.end())
		{
			GLUTs.push_back(PGLUT(new gglut()));
			i = GLUTs.end() -1;
		}

		if(InitGLUT(**i) != gpuppurut::ReturnCode::OK)
		{
		}
	}
}

void Mouse(gpuppurut&, int button, int state, int x, int y)
{
	if(!pressed_left && !pressed_right && state == gpuppurut::NONE)
		return;

	if(state == gpuppurut::NONE)
	{
		current_x = x - begin_mouse_x + begin_x;
		current_y = y - begin_mouse_y + begin_y;

		return;
	}

	if(state == gpuppurut::KEY_DOWN)
	{
		begin_x = current_x;
		begin_y = current_y;
		begin_mouse_x = x;
		begin_mouse_y = y;

		if(button == gpuppurut::MOUSE_LEFT)
		{
			pressed_left = true;
		}

		if(button == gpuppurut::MOUSE_RIGHT)
		{
			pressed_right = true;
		}

		return;
	}else
	{
		if(button == gpuppurut::MOUSE_LEFT)
		{
			pressed_left = false;
		}

		if(button == gpuppurut::MOUSE_RIGHT)
		{
			pressed_right = false;
		}

		return;
	}
}

gpuppurut::ReturnCode InitGLUT(gglut& glut)
{
	glut.setInit3DContextFunc(&OnInitDevice);
	if(small_rand() == 2 || small_rand() == 4)
	{
		glut.setResizeFunc(&Resize);
		glut.setKeyUpFunc(&KeyUp);
		glut.setMouseFunc(&Mouse);

		return glut.initialize(700, 100, std::wstring(L"\\daz"));
	}else
	{
		glut.setResizeFunc(&Resize2);
		glut.setKeyUpFunc(&KeyUp);
		glut.setMouseFunc(&Mouse);

		return glut.initialize(200, 900, std::string("the {\ sX"));
	}
}

}	//end of nameless namespace

void Draw(gglut& glut)
{
	if(glut.get_is_closed())
	{
		return;
	}

	if(glut.get_is_visible() == gpuppurut::ReturnCode::Invisible)
	{
		return;
	}

	if(!glut.begin_scene())
	{
		printf("Failed to begin_scene!!\n");
	}

	static float v = 1.1f;

	glLoadIdentity();

	if(pressed_left)
		glTranslatef((float)current_x/glut.get_width(), -(float)current_y/glut.get_height(), 0.0f);
	if(pressed_right)
		glRotatef(v++, static_cast<float>(current_x), static_cast<float>(-current_y), 1.0f);

	glColor3f(1.0f, 0.0f, 0.0f);

	glBegin(GL_TRIANGLES);
		glVertex2f(0.0f, 1.0f);
		glVertex2f(0.0f, 0.0f);
		glVertex2f(1.0f, 0.0f);
	glEnd();

	gpuppurut::ReturnCode ret = glut.end_scene();
	if(ret != gpuppurut::ReturnCode::Invisible && ret != gpuppurut::ReturnCode::OK)
	{
		printf("Failed to end_scene!!\n");
	}
}

int myMain()
{
	GLUTs.resize(small_rand());

	for(GLUTVecItr i = GLUTs.begin(); i != GLUTs.end(); ++i)
	{
		*i = PGLUT(new gglut());

		gpuppurut::ReturnCode ret = InitGLUT(**i);

		if(ret != gpuppurut::ReturnCode::OK)
		{
			printf("Failed to initialize!!\n");
			return 0;
		}	
	}

	bool done;

	do
	{
		gglut::handle_event();

		done = true;

		for(GLUTVecItr i = GLUTs.begin(); i != GLUTs.end(); ++i)
		{
			done = done && (**i).get_is_closed();
			Draw(**i);
			Sleep(1);
		}

	}while(!done);

	GLUTs.clear();

	return 0;
}

#ifdef _CONSOLE
int _tmain(int argc, _TCHAR* argv[])
{
	setlocale(LC_ALL, "Japanese");	//need to call this function when you use std::wstring or wchar_t.

	gglut::global_initialize(&argc, argv);

	return myMain();
}
#endif

#ifdef _WINDOWS

int APIENTRY _tWinMain(HINSTANCE /*hInstance*/,
                     HINSTANCE /*hPrevInstance*/,
                     LPTSTR    /*lpCmdLine*/,
                     int       /*nCmdShow*/)
{
	setlocale(LC_ALL, "Japanese");

	gglut::global_initialize();

	return myMain();
}

#endif //end of #ifdef _WINDOWS