#ifndef GPUPPURUT_DX_TESTER_HPP
#define GPUPPURUT_DX_TESTER_HPP

#include <gpuppur/gpuppurut/gdxut.hpp>
#include "tester.hpp"

class dx_viewer : public tester
{
public:
	dx_viewer(add_func adder, quit_func quit);
	~dx_viewer();

	void resize(gpuppur::gpuppurut&, int width, int height);
	void draw(gpuppur::gpuppurut& gut);
	bool init_device(gpuppur::gpuppurut& gut);
	void uninit_device(gpuppur::gpuppurut& gut);
	void key_pressing(gpuppur::gpuppurut& gut, int key, int mouse_x, int mouse_y);
	void key_up(gpuppur::gpuppurut& gut, int key, int, int);
	void mouse(gpuppur::gpuppurut&, int button, int state, int x, int y);

	gpuppur::gpuppurut::ReturnCode init(gpuppur::gpuppurut& gut);
	void anim(int frame);

private:
	bool		pressed_left;
	bool		pressed_right;
	int			current_pos_x;
	int			current_pos_y;
	int			current_rot_x;
	int			current_rot_y;
	int			begin_x;
	int			begin_y;
	int			begin_mouse_x;
	int			begin_mouse_y;
	ID3DXMesh*	teapot;
};

#endif