#ifndef LIBRARY

//ggluŎgĂopenglutłfreeglutglutɂ铯OňႤ̊֐(glutInit)gĂB
//freeglutglutheaderɂ̃CuN悤#pragmaĂ̂ŁA
//freeglutglut̃t@CCN[hƎst@C肭삵ȂB
#include <gpuppur/gpuppurut/gglut.hpp>
#include "gl_tester.hpp"
#include <boost/random.hpp>
#include <boost/bind.hpp>
#include <cmath>
#include <GL/openglut.h>

using namespace boost;
using namespace gpuppur;

namespace
{
	boost::mt19937			gen;
	boost::uniform_int<>	binary_dst(0, 1);
	boost::variate_generator<boost::mt19937, boost::uniform_int<> >
							binary_rand(gen, binary_dst);
}

gl_viewer::gl_viewer(add_func add, quit_func quit):
	tester(add, quit),
	pressed_left(false),	pressed_right(false),
	current_pos_x(0),		current_pos_y(0),
	current_rot_x(0),		current_rot_y(0)
{
}

gl_viewer::~gl_viewer()
{
}

void gl_viewer::resize(gpuppurut&, int width, int height)
{
	glViewport(0, 0, width, height);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	glOrtho(-1.0, 1.0, -1.0, 1.0, 1.0, 200);

	glMatrixMode(GL_MODELVIEW);
}

void gl_viewer::draw(gpuppurut& gpuppurut)
{
	gglut& gut = static_cast<gglut&>(gpuppurut);

	if(gut.get_is_visible() != gpuppurut::ReturnCode::Visible)
	{
		return;
	}

	gut.begin_scene();

	glLoadIdentity();

	glTranslatef((GLfloat)this->current_pos_x/gut.get_width(), -(GLfloat)this->current_pos_y/gut.get_height(), -2.0f);
	glRotatef((GLfloat)this->current_rot_x/10.0f, 0.0f, 1.0f, 0.0f);
	glRotatef((GLfloat)this->current_rot_y/10.0f, 1.0f, 0.0f, 0.0f);

	glutSolidTeapot(0.5);

	gut.end_scene();
}

bool gl_viewer::init_device(gpuppurut&)
{
	glClearColor(0.1f, 0.6f, 0.2f, 1.0f);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	float diffuse[]	= { 0.0f, 0.7f, 0.7f, 1.0f };
	glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuse);
	float pos[]		= {0.0, 0.0, 1.0, 0.0f};
	glLightfv(GL_LIGHT0, GL_POSITION, pos);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_CULL_FACE);

	return true;
}

void gl_viewer::key_pressing(gpuppurut& gut, int key, int /*mouse_x*/, int /*mouse_y*/)
{
	const int rot_speed = 32;
	const int mov_speed = 32;

	if(key == gpuppurut::LEFT)
	{
		this->current_rot_x -= rot_speed;
	}else if(key == gpuppurut::RIGHT)
	{
		this->current_rot_x += rot_speed;
	}else if(key == gpuppurut::UP)
	{
		this->current_rot_y += rot_speed;
	}else if(key == gpuppurut::DOWN)
	{
		this->current_rot_y -= rot_speed;
	}else if(key == 'h')
	{
		this->current_pos_x -= mov_speed;
	}else if(key == 'l')
	{
		this->current_pos_x += mov_speed;
	}else if(key == 'j')
	{
		this->current_pos_y += mov_speed;
	}else if(key == 'k')
	{
		this->current_pos_y -= mov_speed;
	}

	gut.redraw();
}

void gl_viewer::key_up(gpuppurut& gpuppurut, int key, int, int)
{
	gglut& glut = static_cast<gglut&>(gpuppurut);

	if(key == gglut::F1)
	{
		glut.set_fullscreen(true);
	}else if(key == gglut::F2)
	{
		glut.set_fullscreen(false);
	}else if(key == '\x1b') //esc key
	{
		glut.uninitialize();
	}else if(key == 'a')
	{
		this->add();
	}else if(key == 'Q')
	{
		this->quit();
	}
}

void gl_viewer::mouse(gpuppurut& gut, int button, int state, int x, int y)
{
	if(state == gpuppurut::NONE)
	{
		if(this->pressed_left)
		{
			this->current_pos_x = x - this->begin_mouse_x + this->begin_x;
			this->current_pos_y = y - this->begin_mouse_y + this->begin_y;
		}else if(this->pressed_right)
		{
			this->current_rot_x = x - this->begin_mouse_x + this->begin_x;
			this->current_rot_y = y - this->begin_mouse_y + this->begin_y;
		}else
		{
			return;
		}

		gut.redraw();
		return;
	}

	if(state == gpuppurut::KEY_DOWN)
	{
		begin_mouse_x = x;
		begin_mouse_y = y;

		if(button == gpuppurut::MOUSE_LEFT)
		{
			pressed_left = true;
			begin_x = current_pos_x;
			begin_y = current_pos_y;
		}

		if(button == gpuppurut::MOUSE_RIGHT)
		{
			pressed_right = true;
			begin_x = current_rot_x;
			begin_y = current_rot_y;
		}

		return;
	}else
	{
		if(button == gpuppurut::MOUSE_LEFT)
		{
			pressed_left = false;
		}

		if(button == gpuppurut::MOUSE_RIGHT)
		{
			pressed_right = false;
		}

		return;
	}
}

gpuppurut::ReturnCode gl_viewer::init(gpuppurut& gut)
{
	gut.setInit3DContextFunc(bind(&gl_viewer::init_device, this, _1));
	gut.setRedrawFunc(bind(&gl_viewer::draw, this, _1));
	gut.setResizeFunc(bind(&gl_viewer::resize, this, _1, _2, _3));
	gut.setKeyPressingFunc(bind(&gl_viewer::key_pressing, this, _1, _2, _3, _4));
	gut.setKeyUpFunc(bind(&gl_viewer::key_up, this, _1, _2, _3, _4));
	gut.setMouseFunc(bind(&gl_viewer::mouse, this, _1, _2, _3, _4, _5));

	gut.initialize(700, 300, std::wstring(L"\\daz"));

	if(binary_rand() == 1)
	{
		return gut.initialize(700, 300, std::wstring(L"\\daz"));
	}else
	{
		return gut.initialize(200, 900, std::string("the {\ sX"));
	}
}

void gl_viewer::anim(int frame)
{
	const int cycle = 300;
	const float move_w = 400.0f, move_h = 400.0f;
	const float rot_w = 800.1f, rot_h = 4000.0f;

	float sita = (frame % cycle)/(float)cycle * 3.141f*2.0f;
	this->current_pos_x = static_cast<int>(move_w * sin(sita*2.0f));
	this->current_pos_y = static_cast<int>(move_h * cos(sita));
	this->current_rot_x = static_cast<int>(rot_w * sin(sita));
	this->current_rot_y = static_cast<int>(rot_h * cos(sita*2.0f));
}

#endif	//end of #ifndef LIBRARY