#ifndef GPUPPURUT_GL_TESTER_HPP
#define GPUPPURUT_GL_TESTER_HPP

#include <gpuppur/gpuppurut/gpuppurut_base.hpp>
#include "tester.hpp"

class gl_viewer : public tester
{
public:
	gl_viewer(add_func adder, quit_func quit);
	~gl_viewer();

	void resize(gpuppur::gpuppurut&, int width, int height);
	void draw(gpuppur::gpuppurut& gpuppurut);
	bool init_device(gpuppur::gpuppurut&);
	void key_pressing(gpuppur::gpuppurut&, int key, int mouse_x, int mouse_y);
	void key_up(gpuppur::gpuppurut& gpuppurut, int key, int, int);
	void mouse(gpuppur::gpuppurut&, int button, int state, int x, int y);
	gpuppur::gpuppurut::ReturnCode init(gpuppur::gpuppurut& gut);
	void anim(int frame);

private:
	bool pressed_left;
	bool pressed_right;
	int current_pos_x;
	int current_pos_y;
	int current_rot_x;
	int current_rot_y;
	int begin_x;
	int begin_y;
	int begin_mouse_x;
	int begin_mouse_y;
};

#endif