#ifndef LIBRARY

#include <gpuppur/gpuppurut/gdxut.hpp>
#include <gpuppur/gpuppurut/gglut.hpp>
#include "gl_tester.hpp"
#include "dx_tester.hpp"

#include <gpuppur/utility/begin_suppress_warnings_from_others_code.hpp>
#include <boost/ptr_container/ptr_list.hpp>
#include <boost/random.hpp>
#include <boost/bind.hpp>
#include <memory>
#include <gpuppur/utility/end_suppress_warnings.hpp>

using namespace gpuppur;
using namespace boost;
using namespace std;

namespace
{
	boost::mt19937			gen;
	static boost::uniform_int<>	binary_dst(0, 1);
	static boost::variate_generator<boost::mt19937, boost::uniform_int<> >
						binary_rand(gen, binary_dst);
}

class windows
{
private:
	struct window
	{
		window()
		{
			is_anim = binary_rand()==1 ? true : false;
		}

		virtual ~window(){}

		virtual gpuppurut::ReturnCode init() = 0;

		virtual gpuppurut& get_gut() = 0;
		bool get_is_anim()
		{
			return this->is_anim;
		}

		void anim(int frame)
		{
			if(this->is_anim)
			{
				this->impl_anim(frame);
			}
		}

		virtual void draw() = 0;

		bool is_anim;

	protected:
		virtual void impl_anim(int frame) = 0;
	};

	template<class GUT, class Handler>
	struct tmpl_window : public window
	{
		tmpl_window(tester::add_func add, tester::quit_func quit):
			window(), handler(add, quit)
		{
		}

		~tmpl_window(){}

		gpuppurut::ReturnCode init()
		{
			return this->handler.init(this->gut);
		}

		gpuppurut& get_gut()
		{
			return this->gut;
		}

		void impl_anim(int frame)
		{
			handler.anim(frame);
		}

		void draw()
		{
			this->gut.redraw();
		}

	private:
		GUT			gut;
		Handler		handler;
	};

	typedef tmpl_window<gglut, gl_viewer>	gl_window;
	typedef tmpl_window<gdxut, dx_viewer>	dx_window;

public:
	windows():done(false)
	{
	}

	void quit()
	{
		this->done = true;
	}

	gpuppurut::ReturnCode	add()
	{
		tester::add_func adder(bind(&windows::add, this));
		tester::quit_func quit(bind(&windows::quit, this));
		auto_ptr<window> ptr(binary_rand() == 1 ? (window*)new gl_window(adder, quit) : new dx_window(adder, quit));

		gpuppurut::ReturnCode ret = ptr->init();
		if(ret != gpuppurut::ReturnCode::OK)
		{
			return ret;
		}

		this->window_list.push_front(ptr.release());

		return gpuppurut::ReturnCode::OK;
	}

	bool process()
	{
		static int frame = 0;

		window_list_itr i;

		if(this->window_list.empty())
		{
			return false;
		}

		bool ret = false;

		for(i=this->window_list.begin(); i!=this->window_list.end(); ++i)
		{
			if(i->get_gut().get_is_closed())
			{
				continue;
			}else
			{
				ret = true;
			}

			if(!i->get_is_anim())
			{
				continue;
			}

			if(!i->get_gut().get_is_visible())
			{
				continue;
			}

			i->anim(frame++);
			i->draw();
		}

		return ret && !done;
	}

private:
	ptr_list<window>					window_list;
	typedef ptr_list<window>::iterator	window_list_itr;
	bool								done;
};

int tester_main()
{
	setlocale(LC_ALL, "Japanese");	//need to call this function when you use std::wstring or wchar_t.

	gglut::global_initialize();
	gdxut::global_initialize();

	windows wins;

	if(wins.add() != gpuppurut::ReturnCode::OK)
	{
		return 1;
	}

	while(wins.process())
	{
		gglut::handle_event();
		Sleep(8);
	}

	return 0;
}

int APIENTRY _tWinMain(HINSTANCE /*hInstance*/,
                     HINSTANCE /*hPrevInstance*/,
                     LPTSTR    /*lpCmdLine*/,
                     int       /*nCmdShow*/)
{
	return tester_main();
}

#endif	//end of #ifndef LIBRARY