#ifndef HEIGHT_MAP_H
#define HEIGHT_MAP_H

#include <vector>
#include <vectorNd.hpp>
#include <line.hpp>

template <typename _real>
class HeightMap
{
public:
	typedef _real				Real;
	typedef std::vector<Real>	Col;
	typedef std::vector<Col>	HeightMap;
	typedef vectorNd<Real, 3>	Vector3D;
	typedef line<Vector3D>		Line;

protected:
	int			width, height;
	HeightMap	heightMap;
	Vector3D	scaler, position;

public:
	HeightMap():
	width(0), height(0)
	{
	}

	HeightMap(int width, int height):
	width(width), height(height),
	heightMap(width, Col(height, Real()))
	{
	}

	HeightMap(int width, int height, const Real* data):
	HeightMap(width, height)
	{
		HeightMap::iterator	i;
		Col::iterator		j;
		Real*			p = data;

		for(i=this->heightMap.begin(); i!=this->heightMap.end(); ++i)
		for(j=i.begin(); j!=i.end(); ++j)
		{
			*j = p++;
		}
	}

	void setScaler(const Vector3D scaler)
	{
		this->scaler = scaler;
	}

	void setPosition(const Vector3D position)
	{
		this->position = position;
	}

	Real& operator()(int x, int y)
	{
		assert(x>=0);
		assert(x<this->width);
		assert(y>=0);
		assert(y<this->height);

		return this->heightMap[x][y];
	}
	
	const Real operator()(int x, int y) const
	{
		assert(x>=0);
		assert(x<this->width);
		assert(y>=0);
		assert(y<this->height);

		return this->heightMap[x][y];
	}

	bool isOver(const Vector3D& point) const
	{
		Vector3D local_p = (point - this->position)/this->scaler;

		int x = (int)local_p[0];
		int z = (int)local_p[2];

		// int plane_index = x*(this->height-1) + z;
		return point[1] >
				(this(x, z)+this(x, z+1)+this(x+1, z)+this(x+1, z+1))/4.0
			 	? true : false;
	}

	void getCross(Vector3D& pos, Vector3D& normal) const
	{
	}
};

#endif
