#ifndef MATH3D_LINE_HPP
#define MATH3D_LINE_HPP

#include "matrixRxC.hpp"

namespace gpuppur
{
/** Line class
 *
 * A Line has position and direction.
 */
template<class _vector>
class Line
{
public:
	typedef _vector Vector;
	typedef _vector vector_type;
	typedef typename Vector::element_type Scaler;
	typedef typename Vector::value_type	value_type;

protected:
	Vector pos;
	Vector dir;

public:
	Line()
	{
	}

	Line(Vector pos, Vector dir)
	:pos(pos), dir(dir)
	{
	}

	Line(Vector pos1, Vector pos2, bool)
	:pos(pos1), dir((pos2 - pos1).getNormalized())
	{
	}

	const Vector getPos() const
	{
		return this->pos;
	}

	const Vector getDir() const
	{
		return this->dir;
	}

	const Vector getPos(Scaler t) const
	{
		return Vector(this->pos + (this->dir*t));
	}
};

template
<
	typename	T,
	std::size_t	Size,
	bool	IsRowMajor
>
const Line<VectorNd<T, Size-1> > operator *
(
	const matrixRxC
	<
		T,
		Size, Size,
		IsRowMajor
	>&									lhs,
	const Line<VectorNd<T, Size-1> >&	rhs
)
{
	typedef VectorNd<T, Size-1>	vector;
	typedef VectorNd<T, Size>	vector_1;

	return Line<vector>
	(
		(lhs*vector_1(rhs.getPos(), 1)).get_sub<0, 3>(),
		get_sub<0, 0, 3, 3>(lhs)*rhs.getDir()
	);
}

}	// end of namespace gpuppur

#endif

