#ifndef MATH3D_MATH_TEST
#define MATH3D_MATH_TEST

/**
 *	@file	
 *	@brief	Test codes for matrix and vector template classes.
 *	@author	Tomohiro Matsumoto
 */

#include <cassert>
#include <iostream>
#include "vectorNd.hpp"
#include "matrixRxC.hpp"
#include "axis_aligned_bounding_box.hpp"

inline void math_test()
{
	std::cout << "begin test" << std::endl;
	std::cout << std::boolalpha;

	// types used in test.
	typedef gpuppur::VectorNd<int, 4>	vec4i;
	typedef gpuppur::VectorNd<int, 3>	vec3i;
	typedef gpuppur::VectorNd<int, 2>	vec2i;
	typedef gpuppur::VectorNd<int, 1>	vec1i;
	typedef gpuppur::VectorNd<float, 4>	vec4f;
	typedef gpuppur::VectorNd<float, 3>	vec3f;
	typedef gpuppur::VectorNd<float, 2>	vec2f;
	typedef gpuppur::VectorNd<float, 1>	vec1f;

	// Literals used in test.
	gpuppur::matrixRxC<int, 4,4> mat4x4
	(
		vec4i(1, vec3i(2, 4, 5)),
		vec4i(1, 2, -4, 1),
		vec4i(0, -2, 1, 3),
		vec4i(3, 3, -3, 1)
	);
	gpuppur::matrixRxC<int, 3, 3> mat4x4_cofactor_3_3
	(
		vec3i(1, 1, 0),
		vec3i(2, 2, -2),
		vec3i(4, -4, 1),
		false
	);
	gpuppur::matrixRxC<int, 3, 3> mat4x4_cofactor_1_1
	(
		vec3i(1, 4, 5),
		vec3i(0, 1, 3),
		vec3i(3, -3, 1)
	);
	gpuppur::matrixRxC<int, 4,2> mat4x2
	(
		vec2i(2, 1),
		vec2i(-1, 3),
		vec2i(1, -2),
		vec2i(0, -3)
	);
	gpuppur::matrixRxC<int, 2,4> mat2x4
	(
		vec4i(3, -1, 2, -2),
		vec4i(1, 1, -3, 2)
	);
/*	gpuppur::matrixRxC<int, 4, 4> mat4x2_x_mat2x4
	(
		7, -1, 1, -2,
		0, 4, -11, 8,
		1, -3, 8, -6,
		-3, -3, 9, -6
	);*/
	gpuppur::matrixRxC<int, 4, 4> mat4x2_x_mat2x4
	(
		vec4i(7, 0, 1, -3),
		vec4i(-1, 4, -3, -3),
		vec4i(1, -11, 8, 9),
		vec4i(-2, 8, -6, -6),
		false
	);
	gpuppur::matrixRxC<int, 2, 2> mat2x4_x_mat4x2
	(
		9, 2,
		-2, 4
	);
	gpuppur::matrixRxC<int, 1, 1> mat2x4_x_mat4x2_cofactor_0_0
	(
		4
	);
	gpuppur::matrixRxC<int, 3, 1, false> mat3x1
	(
		1,
		2,
		3
	);
	gpuppur::matrixRxC<int, 1, 1> mat1x1(2);
	gpuppur::matrixRxC<int, 3, 1, false> mat3x1_x_mat1x1
	(
		2,
		4,
		6
	);
	gpuppur::matrixRxC<int, 2, 3, false> mat2x3
	(
		0, 1, -2,
		2, -1, 0
	);
	gpuppur::matrixRxC<int, 3, 2> mat2x3_transposed
	(
		0, 2,
		1, -1,
		-2, 0
	);
	gpuppur::matrixRxC<int, 2, 1, false> mat2x3_x_mat3x1
	(
		-4,
		0
	);
	gpuppur::matrixRxC<int, 3, 3> mat3x3
	(
		1, 4, -2,
		1, 0, 3,
		0, -1, 2
	);
	gpuppur::matrixRxC<int, 3, 3> mat3x3_transposed
	(
		1, 1, 0,
		4, 0, -1,
		-2,3, 2
	);

	{
		vec1i vec1(-2);
		vec3i vec3(2, -1, 0);
		assert
		((
			vec4i(5, 1, 5, 4)
			==
			mat4x4*vec4i(2, -1, 0, 1)
		));
//		std::cout << boolalpha << (mat4x4==cmat4x4)<<std::endl<<std::endl;
	
		assert(mat4x2*mat2x4==mat4x2_x_mat2x4);
		assert(mat2x4*mat4x2==mat2x4_x_mat4x2);
		assert(mat3x1*mat1x1==mat3x1_x_mat1x1);
		assert(mat2x3*mat3x1==mat2x3_x_mat3x1);
		assert((gpuppur::get_sub<0, 0, 4, 4>(mat4x2_x_mat2x4)
				==mat4x2_x_mat2x4));
		assert((gpuppur::get_sub_major<0, 1, 2, 3, true>(mat2x3)[2]
				==mat2x3[3]));
		{
			gpuppur::matrixRxC<int, 4, 4> tmp;
			gpuppur::set_sub(tmp, mat2x3, 1, 1);
			assert((gpuppur::get_sub<1, 1, 3, 4>(tmp) == mat2x3));
			gpuppur::set_sub(tmp, mat4x4, 0, 0, 0, 0, 4, 4);
			assert((gpuppur::get_sub<0, 0, 4, 4>(tmp) == mat4x4));
		}

		assert
		(
			gpuppur::get_cofactor(mat2x4_x_mat4x2, 0, 0)
			==
			mat2x4_x_mat4x2_cofactor_0_0
		);
		assert
		(
			gpuppur::get_cofactor(mat4x4, 3, 3)
			==
			mat4x4_cofactor_3_3
		);
		assert
		(
			gpuppur::get_cofactor(mat4x4, 1, 1)
			==
			mat4x4_cofactor_1_1
		);
		assert
		(
			gpuppur::get_transposed(mat2x3)
			==
			mat2x3_transposed
		);
		assert
		(
			gpuppur::get_transposed(mat3x3)
			==
			mat3x3_transposed
		);
		assert(get_determinant(mat3x3)==2+3-8);
		{
			gpuppur::matrixRxC<double, 4, 4> mat4x4f
			(
				2.0, 4.0, -1.0, 1.0,
				-2.0, 16.0, 1.0, 2.0,
				-4.0, -1.0, 2.0, 2.0,
				1.0, 2.0, -2.0, 1.0
			);
		//	std::cout << gpuppur::get_inversed(mat4x4f) << std::endl;
		//	std::cout << mat4x4f << std::endl;
		//	std::cout << gpuppur::get_determinant(mat4x4f) << std::endl;
			std::cout << gpuppur::get_inversed(mat4x4f)*mat4x4f << std::endl;
		/*	assert
			((
				gpuppur::get_inversed(mat4x4f)*mat4x4f
				==
				gpuppur::matrixRxC<double, 4, 4>().load_unit_matrix()
			));*/
		}
	}
	{
		gpuppur::matrixRxC<int, 2,4> mata
		(
			0, 1, 1, 2,
			3, 5, 8, 11
		);
		gpuppur::matrixRxC<int, 1,4, false> matb(19, 30, 49, 79);
		gpuppur::matrixRxC<int, 3,4, false> mat(mata, matb);
		gpuppur::matrixRxC<int, 3,4, false> clct
		(
			vec3i(0, 3, 19),
			vec3i(1, 5, 30),
			vec3i(1, 8, 49),
			vec3i(2, 11, 79)
		);
		assert(mat==clct);

		vec4i vec4(4000, 300, 20, 1);
		const vec4i vec4_c(4000, 300, 20, 1);

		assert(vec4==vec4_c);

		vec3i vec0_3(4000, 300, 20);
		vec3i vec1_4(300, 20, 1);

		assert((vec4.get_sub<0, 3>() == vec0_3));
		assert((vec4_c.get_sub<1, 4>() == vec1_4));

		vec4i vec3_1_4(vec0_3, 1);

		vec4i vec1_3_4(4000, vec1_4);
		assert(vec3_1_4==vec1_3_4 && vec3_1_4==vec4);
	//	vec4_c.get_sub<0, 3>() = vec1_4;	//compile error

		vec4.get_sub<0, 3>() = vec1_4;
		assert((vec4.get_sub<0, 3>() == vec1_4));
	}
	{
		// template test
		vec2f::scaled_type<2>::type vec0(vec2i(0, 1), vec2i(2, 3));
		vec1i::increased_type<3>::type vec1(vec0);

		assert(vec1 == vec4i(vec4f(0.0f, 1.0f, 2.0f, 3.0f)));
		assert(vec4i(1) == vec4i(1.0f));
	}

	//aabb test
	{
		typedef gpuppur::aabb<vec3f>	aabbv3f;

		vec3f min = vec3f(-1.0f, -1.0f, -1.0f), max = vec3f(1.0f, 1.0f, 1.0f);
		vec3f verts[] = {min, max};
		vec3f verts_r[] = {max, min};
 
		aabbv3f box = gpuppur::get_axis_aligned_bounding_box
		(
			&verts[0],
			verts+2
		);

		assert(box.get_min() == min);
		assert(box.get_max() == max);

		box = gpuppur::get_axis_aligned_bounding_box
		(
			verts_r,
			verts_r+2
		);

		assert(box.get_min() == min);
		assert(box.get_max() == max);

		typedef gpuppur::Line<vec3f>	ray;

		ray ray0(vec3f(0.0f, 0.0f, -2.0f), vec3f(0.0f, 0.0f, 1.0f));
		boost::tuple<float, float, int, int> ret =
		gpuppur::cast_ray_to_aabb(box, ray0);

		assert(boost::get<0>(ret) == 1.0f);
		assert(boost::get<1>(ret) == 3.0f);
		assert(boost::get<2>(ret) == 2);
		assert(boost::get<3>(ret) == 5);

		std::vector<aabbv3f>	boxes(8);

		gpuppur::get_uniform_divided_aabbs
		(
			box, vec3f(2.0f, 2.0f, 2.0f),
			boxes.begin()
		);

		vec3f mid = (box.get_min()+box.get_max())/2.0f;
		assert(boxes.at(0).get_min() == box.get_min());
		assert
		(
			(boxes.at(0).get_max() == boxes.at(7).get_min())
			&&
			(mid == boxes.at(0).get_max())
		);
		assert(boxes.at(7).get_max() == box.get_max());
		assert
		(
			boxes.at(1).get_min()[2] == boxes.at(2).get_max()[2]
			&&
			boxes.at(3).get_min()[2] == boxes.at(4).get_max()[2]
			&&
			boxes.at(6).get_max()[2] == boxes.at(7).get_min()[2]
		);
		assert
		(
			boxes.at(0).get_max()[0] == boxes.at(1).get_max()[0]
			&&
			boxes.at(2).get_max()[0] == boxes.at(3).get_max()[0]
			&&
			boxes.at(4).get_min()[0] == boxes.at(5).get_min()[0]
			&&
			boxes.at(6).get_min()[0] == boxes.at(7).get_min()[0]
		);
	}
}

#endif
