#ifndef NUM_CONVERT_HPP
#define NUM_CONVERT_HPP

/**
 *	@file	
 *	@brief	Functions for convert special float type value to unsigned 16bit integer.
 *	@author	Tomohiro Matsumoto
 */

namespace
{

typedef unsigned short ui16;
typedef unsigned int ui32;

union f_i
{
	float f;
	ui32 i;
};

int get_exp(float v)
{
	return 127 - ((*(union f_i*)&v).i >> 23);

}

ui32 get_frac(float v)
{
	return (*(union f_i*)&v).i&0x7fffff | 0x800000;
}

}	//end of namespace{}


inline ui16 to_ui16_from_0_1(float v)
{
	int exp = get_exp(v);

	ui32 frac = get_frac(v);

//	return ((frac >> exp)-(1>>exp)) >> 7;
	return static_cast<ui16>( (frac-1) >> exp >> 7 );
}

inline ui16 to_ui16_from_n1_1(float v)
{
	int exp = get_exp(v);

	ui32 frac = get_frac(v);

	ui32 tmp = (frac-1) >> (exp&0xff) >> 8;
	exp = exp>>8;

	return
		static_cast<ui16>
		(
			(0x7fff - tmp) >> ((16 << exp)&16) |
			(tmp | 0x8000) >> (exp&16)
		);
}

#endif
