#ifndef MATH3D_TRIANGLE_HPP
#define MATH3D_TRIANGLE_HPP

#include <cassert>
#include <boost/mpl/integral_c.hpp>
#include "vectorNd.hpp"


namespace gpuppur
{

/** Triangle Class
 *
 */
template<class Vector>
class triangle
{
public:

	typedef typename Vector::value_type	value_type;
	typedef Vector						vector_type;

private:

	static bool isInner(
			    value_type x,  value_type y,
			    value_type ex, value_type ey,
			    value_type fx, value_type fy)
	{
		value_type nx = -ey, ny = ex;

		return (nx*fx+ny*fy)*(nx*x+ny*y) >= 0;
	}

	static bool isInTriangle(
				value_type x, value_type y,
				value_type x0, value_type y0,
				value_type x1, value_type y1,
				value_type x2, value_type y2)
	{
		return isInner(x-x0, y-y0, x1-x0, y1-y0, x2-x0, y2-y0) &&
		       isInner(x-x1, y-y1, x2-x1, y2-y1, x0-x1, y0-y1) &&
		       isInner(x-x2, y-y2, x0-x2, y0-y2, x1-x2, y1-y2);
	}

public:
/*
	class func
	{
	private:
		const Vector& on;
	//	const Vector (&triangle)[3];
		const Vector& v0, v1, v2;

	public:
		func
		(
			const Vector& on,
			const Vector& v0,
			const Vector& v1,
			const Vector& v2
		)
		:on(on), v0(v0), v1(v1), v2(v2)
		{
		}

		template<std::size_t v>
		bool operator () (boost::mpl::integral_c<std::size_t, v>) const
		{
			typedef boost::mpl::integral_c<std::size_t, v> arg;
			const std::size_t x =
			(9 >> (arg::value<<1)) & 3;
			const std::size_t y =
			(18 >> (arg::value<<1)) & 3;

			return 
			isInTriangle
			(
			 	on[x], on[y],
				v0[x], v0[y],
				v1[x], v1[y],
				v2[x], v2[y]
			);
		}
	};
*/
	static value_type
	get_cross
	(
		const Vector& ray_pos,
		const Vector& ray_dir,
		const Vector& v0,
		const Vector& v1,
		const Vector& v2,
		Vector& pos,
		Vector& normal
	)
	{
		//Counter clock wise.
		Vector va = v1-v0;
		Vector vb = v2-v0;
		normal = va.outerProduct(vb);
		normal.normalize();

		if(normal.innerProduct(ray_dir) > 0.0)
		{
			return -1.0;
		}

		Vector relative_pos = v0 - ray_pos;

		if(normal.innerProduct(relative_pos) > 0.0)
		{
			return -1.0;
		}

		value_type D = normal.innerProduct(ray_dir);
		if(D == 0)
		{
			return -1.0;
		}

		value_type t = normal.innerProduct(relative_pos) / D;

		Vector on = ray_pos+ray_dir*t;

		bool isin;

		if
		(
			normal[0]*normal[0] > normal[1]*normal[1]
			&&
			normal[0]*normal[0] > normal[2]*normal[2]
		)
		{
			isin = isInTriangle
			(
				on[1], on[2],
				v0[1], v0[2],
				v1[1], v1[2],
				v2[1], v2[2]
			);
		}else if(normal[1]*normal[1] > normal[2]*normal[2])
		{
			isin = isInTriangle
			(
				on[2], on[0],
				v0[2], v0[0],
				v1[2], v1[0],
				v2[2], v2[0]
			);
		}else
		{
			isin = isInTriangle
			(
				on[0], on[1],
				v0[0], v0[1],
				v1[0], v1[1],
				v2[0], v2[1]
			);
		}

		pos = on;
		return isin ? t : -1;
	}
};

}	//end of namespace gpuppur

#endif
