#ifndef ERROR_REPORT_COMMON_HPP
#define ERROR_REPORT_COMMON_HPP

/**
 *	@file	
 *	@brief	Functions and macros for reporting error.
 *	@author	Tomohiro Matsumoto
 */

#ifndef NDEBUG
#ifndef NOLOG
	#define BUILD_DEBUG_PRINTER
#endif
#endif


#ifndef _MSC_VER

	#ifdef UNICODE
		typedef wchar_t _TCHAR;
		#define _T(n) L##n
	#else
		typedef char _TCHAR;
		#define _T(n) n

		#define _vsntprintf	vsnprintf

	#endif

	#ifdef __CYGWIN__
		#include <string>
		#include <sstream>
		#include <cwchar>
		#include <iostream>

		namespace std
		{
			typedef std::basic_string<wchar_t> wstring;

			std::basic_stringbuf<wchar_t> wstrbuf;
			std::basic_ostream<wchar_t> wcerr(&wstrbuf);
		}
	#endif

#else
	#include <tchar.h>
#endif


#ifdef BUILD_DEBUG_PRINTER

#include <gpuppur/utility/begin_suppress_warnings_from_others_code.hpp>

#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <cstdio>
#include <cstdarg>
#include <ctime>
#include <boost/date_time/posix_time/posix_time.hpp>

#include <gpuppur/utility/end_suppress_warnings.hpp>

namespace gpuppur
{
	class error_report_common
	{
	private:

		const static std::size_t MAXPRINTMSG = 4096;

		#ifdef UNICODE
			typedef std::wostringstream	tostringstream;
			typedef std::wstring		tstring;
		#else
			typedef std::ostringstream	tostringstream;
			typedef std::string			tstring;
		#endif

	public:

		static void print(const _TCHAR* msg)
		{
			static std::string filename;
			bool isFirst = false;

			if( filename.empty() )
			{
				std::ostringstream oss;
				//	oss << time(NULL) ;
				filename = "debug_out_";
				//	filename += oss.str() + ".txt";
				tm pt_tm
				=
				boost::posix_time::to_tm
				(
					boost::posix_time::second_clock::local_time()
				);

				oss << (pt_tm.tm_year+1900) << "_" <<
					   (pt_tm.tm_mon+1) << "_" <<
					   (pt_tm.tm_mday) << "_" <<
					   (pt_tm.tm_hour) << "h" <<
					   (pt_tm.tm_min) << "m" <<
					   (pt_tm.tm_sec) << "s.txt";
				filename += oss.str();

				isFirst = true;
			}

		//This code cant output unicode char correctly, even if i use wofstream.
		#ifndef UNICODE
			std::ofstream output(filename.c_str(), std::ios_base::app);

			output << msg << std::endl;
			output.flush();
			output.close();
		#else

			_TCHAR converted[MAXPRINTMSG*2+1];
			int cpy = 0;
			_TCHAR* end = converted;
			std::size_t i;

			//need to convert '\n' to CR LF, if unicode is enabled.
			std::size_t len = _tcslen(msg);
			for(i = 0; i<len+1; i++)
			{
				if(msg[i] == '\n' || i == len)
				{
					if(i!=0)
					{
						_tcsncpy(end, &msg[i-cpy], cpy);
						end += cpy;
					}
					end[0] = 0x000d;
					end[1] = 0x000a;	//Formal line feed in windows.(CR LF)
					end[2] = 0;
					end += 2;
					cpy = 0;
				//	const_cast<_TCHAR*>(msg)[i]  = 0x2029;
				}else
				{
					cpy++;
				}
			}

			msg = converted;

			FILE* fp;
			fp = fopen(filename.c_str(), "ab");
			if(fp == NULL)
			{
				return;
			}

			const unsigned short bom = 0xfeff;
			if(isFirst)
			{
				fwrite(&bom, sizeof(unsigned short), 1, fp);
			}
			fwrite(msg, _tcslen(msg)*sizeof(_TCHAR), 1, fp);
			fclose(fp);
		#endif
		}

	public:
		
		static void debug_print
		(
			const _TCHAR* const file,
			int line,
			const _TCHAR* const msg, ...
		)
		{
			va_list		argptr;
			_TCHAR		out[MAXPRINTMSG];
			int			writed_count = 0;

		/*
			writed_count = _sntprintf(out, MAXPRINTMSG,
		#ifdef UNICODE
				_T("In %ls:%d\n"),
		#else
				_T("In %s:%d\n"),
		#endif
				file, line);
		*/
			tostringstream oss;
			oss << _T("In ") << file << ":" << line;

			if(writed_count < 0)
			{
				out[MAXPRINTMSG-1] = 0;
				print(out);
				return;
			}

			va_start(argptr, msg);
			writed_count = _vsntprintf(out/* +_tcsclen(out)*/, MAXPRINTMSG-writed_count, msg, argptr);
			va_end(argptr);

			if(writed_count < 0)
			{
				out[MAXPRINTMSG-1] = 0;
			}

		//	print(out);
			print(tstring(oss.str()+_T("\n")+out).c_str());
		}
	};
}	// end of namespace gpuppur

	#define DebugPrint(msg, ...)  gpuppur::error_report_common::debug_print	\
								  (_T(__FILE__), __LINE__, msg, __VA_ARGS__)

	#ifdef _WIN32

		inline void ShowLastWinAPIError()
		{
			LPVOID lpMsgBuf;

			FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
			NULL, GetLastError(), MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
			(LPTSTR)&lpMsgBuf, 0, NULL);

			gpuppur::error_report_common::print((LPCTSTR)lpMsgBuf);

			LocalFree(lpMsgBuf);
		}

	#endif

#else

	#define DebugPrint

	#ifdef _WIN32
		#define ShowLastWinAPIError()
	#endif

#endif

#endif

