#ifndef ERROR_REPORT_DX_HPP
#define ERROR_REPORT_DX_HPP

/**
 *	@file	
 *	@brief	Macros for check and handle error of DirectX9.
 *	@author	Tomohiro Matsumoto
 */

#include <gpuppur/error_manage/error_report_common.hpp>

#include <gpuppur/utility/begin_suppress_warnings_from_others_code.hpp>
#include <string>
#include <sstream>
#include <fstream>
#include <crtdbg.h>
#include <Dxerr.h>
#include <gpuppur/utility/end_suppress_warnings.hpp>

#if 0

// Err check macros
// Specialized for directx function.
// These macros were disabled if you define "NDEBUG"
/*
USE_ERR_CHECK;					Write this macro if you use these macros.
TRY								Put this macro before the function which you want to check err.
CATCH(char *msg);				Put this macro next to the function which you want to check err.
								This macro doesnt exit outside function even if it find err.
FAIL(char *msg, returnValue);	Put this macro next to the function which you want to check err.
								When this macro find err, this macro will return "returnValue"
								to function which called outside function of this macro.
DebugPrint(char *msg, ...);		Print debug message.
*/
#endif

// Example
/*
bool foo(void)
{
	USE_ERR_CHECK;

	TRY											//Dont put ";" after "TRY" macro.
	DirectXFunc();								//̊֐D3D_OKȊOԂ
	FAIL("DirectXFunc() Failed !!\n", false);	//t@CƍsƎw肵
												//bZ[W\falseԂB
	return true;
}
*/

#ifdef BUILD_DEBUG_PRINTER

//	const _TCHAR* _get_dx_err_string(HRESULT hr);
//	const _TCHAR* _get_dx_err_description(HRESULT hr);

	namespace gpuppur
	{
		class error_report_dx
		{
		public:

			static const _TCHAR* get_dx_err_string(HRESULT hr)
			{
				return DXGetErrorString(hr);
			}

			static const _TCHAR* get_dx_err_description(HRESULT hr)
			{
				return DXGetErrorDescription(hr);
			}
		};
	}	//end of namespace gpuppur

	#define TRACE_ERR(n, h) DebugPrint(								\
							_T("%s\nError String:%s\nError Description:%s\n"),	\
							n,													\
							gpuppur::error_report_dx::get_dx_err_string(h),		\
							gpuppur::error_report_dx::get_dx_err_description(h))
	#define USE_ERR_CHECK HRESULT __result
	#define TRY __result =
	#define CATCH(n) do{											\
						if(FAILED(__result)){						\
							TRACE_ERR(n, __result);					\
						}											\
					}while(get_false())
	#define FAIL(n, m) do{											\
							if(FAILED(__result)){					\
								TRACE_ERR(n, __result);				\
								return m;							\
							}										\
						}while(get_false())

	#define V(n)	do{												\
						HRESULT __V_result_V = (n);					\
						if(FAILED(__V_result_V)){					\
							TRACE_ERR(								\
								_T("failed ")##_T(#n),				\
								__V_result_V);						\
						}											\
					}while(get_false())

	#define V_RET(n) do{											\
						HRESULT __V_result_V = (n);					\
						if(FAILED(__V_result_V)){					\
							TRACE_ERR(_T("failed ")##_T(#n), __V_result_V);	\
							return __V_result_V;					\
						}											\
					}while(get_false())

	#define B_RET(n) do{											\
						HRESULT __V_result_V = (n);					\
						if(FAILED(__V_result_V)){					\
							TRACE_ERR(_T("failed ")##_T(#n), __V_result_V);	\
							return false;							\
						}											\
					}while(get_false())

	#define T_RET(n, ret) do{										\
						HRESULT __V_result_V = (n);					\
						if(FAILED(__V_result_V)){					\
							TRACE_ERR(_T("failed ")##_T(#n), __V_result_V);	\
							return ret;								\
						}											\
					}while(get_false())

	inline void VSIDEPrint(const std::string& msg)
	{
		static int count;

		std::string output(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n  <%d>  ");
		output.append(msg);
		output.append("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");

		_RPT1(_CRT_WARN, output.c_str(), count++);
	}

	// Hack for disable warning C4819(condition expression is constant).
	// Above macros using do-while(false).
	namespace{
		bool get_false(){return false;}
	}

#else

	#define TRACE_ERR(n, h)
	#define USE_ERR_CHECK
	#define GET_ERR
	#define TRY
	#define CATCH(n)
	#define FAIL(n, m)

	#define V(n)			(n)
	#define V_RET(n)		(n)
	#define B_RET(n)		(n)
	#define T_RET(n, ret)	(n)

	#define VSIDEPrint

#endif


#ifndef SAFE_DELETE
    #define SAFE_DELETE(p)       { if(p) { delete (p);     (p)=NULL; } }
#endif    
#ifndef SAFE_DELETE_ARRAY
    #define SAFE_DELETE_ARRAY(p) { if(p) { delete[] (p);   (p)=NULL; } }
#endif    
#ifndef SAFE_RELEASE
    #define SAFE_RELEASE(p)      { if(p) { (p)->Release(); (p)=NULL; } }
#endif

#endif

