#ifndef GPUPPUR_GPU_BUF
#define GPUPPUR_GPU_BUF

#include <gpuppur/utility/begin_suppress_warnings_from_others_code.hpp>
#include <boost/call_traits.hpp>
#include <boost/iterator/iterator_facade.hpp>
#include <boost/mpl/void.hpp>
#include <boost/mpl/int.hpp>
#include <boost/tuple/tuple.hpp>
#include <gpuppur/utility/end_suppress_warnings.hpp>

#include <gpuppur/utility/utility.hpp>

namespace gpuppur
{
	template<class Implement>
	class g_buffer;

	template
	<
		template<class> class TexBufImpl=gl_texbuf,
		template<class> class FastTexBufImpl=gl_pbo_buf
	>
	class gpu_buf:
		public g_buffer
		<
			gpu_buf<TexBufImpl, FastTexBufImpl>
		>
	{
	public:

		typedef texbuf<vector1ui16, /*TexBufImpl/*/TexBufImpl/**/>
				normal_buf_type;
		typedef texbuf<vector4ui16, FastTexBufImpl>
				material_buf_type;

		typedef typename normal_buf_type::context_type context_type;
		typedef typename boost::call_traits<context_type>::param_type
				context_param_type;

		typedef boost::tuple<normal_buf_type, material_buf_type> data_type;

		data_type data;

		const static std::size_t num_data=2;// = boost::tuples::length<data_type>::value;

		template<int N>
		typename boost::tuples::element<N, data_type>::type& get_data(boost::mpl::int_<N>)
		{
			return boost::get<N>(this->data);
		}
/*
		data_type0&	get_data(boost::mpl::int_<0>)
		{
			return this->data.get<0>();
		}

		data_type1&	get_data(boost::mpl::int_<1>)
		{
			return this->material_buf;
		}
*/
		typedef boost::tuple<vector1ui16*, vector4ui16*> buf_pointers_type;

	public:

		typedef gpu_buf this_type;

		class buf_iterator : public
							boost::iterator_facade
							<
								buf_iterator,
								boost::mpl::void_,
								boost::random_access_traversal_tag
							>
							//boost::addable<buf_iterator, int/*, buf_iterator*/>,
							//boost::subtractable<buf_iterator, int/*, buf_iterator*/>
		{
		public:

			typedef buf_iterator this_type;

			buf_pointers_type current_iterator;
			const static std::size_t num_pointer = 2;

		#ifndef NDEBUG
			buf_pointers_type begin_iterator;
			buf_pointers_type end_iterator;

			void set_bound
			(
				const buf_pointers_type& begin,
				const buf_pointers_type& end)
			{
				this->begin_iterator = begin;
				this->end_iterator = end;
			}
			void set_bound(const this_type& src)
			{
				this->begin_iterator = src.begin_iterator;
				this->end_iterator = src.end_iterator;
			}
			#define ASSERT_NOT_OUT_OF_RANGE(itr)					\
				assert												\
				(													\
						boost::get<0>((itr).current_iterator)		\
						>=											\
						boost::get<0>((itr).begin_iterator)			\
					&&												\
						boost::get<1>((itr).current_iterator)		\
						>=											\
						boost::get<1>((itr).begin_iterator)			\
					&&												\
						boost::get<0>((itr).current_iterator)		\
						<											\
						boost::get<0>((itr).end_iterator)			\
					&&												\
						boost::get<1>((itr).current_iterator)		\
						<											\
						boost::get<1>((itr).end_iterator)			\
				);
		#else
			void set_bound(...){}
			#define ASSERT_NOT_OUT_OF_RANGE(itr)
		#endif

			buf_iterator(const buf_iterator& src):
				current_iterator(src.current_iterator)
			{
				this->set_bound(src);
			}

			void write(const vector3& normal, const vector3& material) const
			{
				ASSERT_NOT_OUT_OF_RANGE(*this);

				*(boost::get<0>(this->current_iterator))
				=
				vector1ui16(to_ui16_from_n1_1(normal[1]));

				*(boost::get<1>(this->current_iterator))
				=
				vector4ui16
				(
					to_ui16_from_0_1(material[0]),
					to_ui16_from_0_1(material[1]),
					to_ui16_from_0_1(material[2]),
					to_ui16_from_n1_1(normal[0])
				);
			}

			void write(const this_type& src) const
			{
				ASSERT_NOT_OUT_OF_RANGE(*this);
				ASSERT_NOT_OUT_OF_RANGE(src);

				*(boost::get<0>(this->current_iterator))
				=
				*boost::get<0>(src.current_iterator);

				*(boost::get<1>(this->current_iterator))
				=
				*boost::get<1>(src.current_iterator);
			}

			void write_while()const
			{
				ASSERT_NOT_OUT_OF_RANGE(*this);

				*(boost::get<0>(this->current_iterator))
				=
				vector1ui16((unsigned short)0x7fff);

				*(boost::get<1>(this->current_iterator))
				=
				vector4ui16
				(
					0xffff,
					0xffff,
					0xffff,
					0x7fff
				);
			}

			bool is_same_mtrl(const this_type& rhs) const
			{
				ASSERT_NOT_OUT_OF_RANGE(rhs);
				ASSERT_NOT_OUT_OF_RANGE(*this);

				return
					boost::get<1>(this->current_iterator)->get_sub<0,3>()
					==
					boost::get<1>(rhs.current_iterator)->get_sub<0, 3>();
			}

			bool is_same_normal(const this_type& rhs) const
			{
				ASSERT_NOT_OUT_OF_RANGE(rhs);
				ASSERT_NOT_OUT_OF_RANGE(*this);


				const static unsigned short closeness = 0xc000;//~(0xffff >> 13);

				return
			#if 0
				VectorNd<int, 2>
				(
					(
						(*this->current_iterator.get<0>())[0]
						-
						(*rhs.current_iterator.get<0>())[0]
					),
					(
						(*this->current_iterator.get<1>())[3]
						-
						(*rhs.current_iterator.get<1>())[3]
					)
				).length2<float>() < /*1048576*//*67108864.0f*/27374182.0f;
			#else

				((*boost::get<0>(this->current_iterator))[0] & closeness)
				==
				((*boost::get<0>(rhs.current_iterator))[0] & closeness)
				&&
				((*boost::get<1>(this->current_iterator))[3] & closeness)
				==
				((*boost::get<1>(rhs.current_iterator))[3] & closeness);
			#endif
			}

		private:

			void advance(std::ptrdiff_t n)
			{
				ASSERT_NOT_OUT_OF_RANGE(*this);

				boost::get<0>(this->current_iterator) += n;
				boost::get<1>(this->current_iterator) += n;
			}

			std::ptrdiff_t distance_to(const this_type& rhs) const
			{
				return
					boost::get<0>(rhs.current_iterator)
					-
					boost::get<0>(this->current_iterator);
			}

			buf_iterator(const buf_pointers_type& pointer):
				current_iterator(pointer)
			{
			}

			friend class gpu_buf;
			friend class boost::iterator_core_access;
		};	//end of class buf_iterator 
/*
		void uninitialize()
		{
			this->normal_buf.uninitialize();
			this->material_buf.uninitialize();
		}
*/
		bool initialize
		(
			std::size_t								width,
			std::size_t								height,
			typename this_type::context_param_type	context
		)
		{
			if(!boost::get<0>(this->data).initialize(width, height, 0, context))
			{
				std::cerr << "Failed to initialize normal buffer." << std::endl;
				return false;
			}

			if(!boost::get<1>(this->data).initialize(width, height, 1, context))
			{
				std::cerr << "Failed to initialize material buffer." << std::endl;
				return false;
			}

			return true;
		}

		bool	lock_for_write()
		{
			if(!boost::get<1>(this->data).lock_for_write())
			{
				return false;
			}

			if(!boost::get<0>(this->data).lock_for_write())
			{
				return false;
			}

			return true;
		}

		bool	unlock()
		{
			if(!boost::get<1>(this->data).unlock())
			{
				return false;
			}

			if(!boost::get<0>(this->data).unlock())
			{
				return false;
			}

			return true;
		}

		void	activate(typename this_type::context_param_type	context)
		{
			boost::get<1>(this->data).activate(context);
			boost::get<0>(this->data).activate(context);
		}

		template<class ShaderClass>
		void	bind_to_shader(ShaderClass& shader)
		{
			shader.set_uniform_texture("texture0", boost::get<0>(this->data));
			shader.set_uniform_texture("texture1", boost::get<1>(this->data));
		}

		const buf_iterator get_iterator()
		{
			buf_iterator ret
			(
				buf_pointers_type
				(
					boost::get<0>(this->data).get_buf_ptr(),
					boost::get<1>(this->data).get_buf_ptr()
				)
			);

			ret.set_bound
			(
				buf_pointers_type
				(
					boost::get<0>(this->data).get_buf_ptr(),
					boost::get<1>(this->data).get_buf_ptr()
				),
				buf_pointers_type
				(
					boost::get<0>(this->data).get_buf_ptr()
					+
					boost::get<0>(this->data).get_width()*boost::get<0>(this->data).get_height(),
					boost::get<1>(this->data).get_buf_ptr()
					+
					boost::get<1>(this->data).get_width()*boost::get<1>(this->data).get_height()
				)
			);

			return ret;
		}

		class sum;
		class variance;
		bool is_similar
		(
			const buf_iterator& s0,
			const buf_iterator& s1,
			const buf_iterator& s2,
			const buf_iterator& s3
		) const
		{
/*
			sum s;
			gpuppur::tuple_for_each(s0.current_iterator, s);
			gpuppur::tuple_for_each(s1.current_iterator, s);
			gpuppur::tuple_for_each(s2.current_iterator, s);
			gpuppur::tuple_for_each(s3.current_iterator, s);


			variance v(s);
			gpuppur::tuple_for_each(s0.current_iterator, v);
			gpuppur::tuple_for_each(s1.current_iterator, v);
			gpuppur::tuple_for_each(s2.current_iterator, v);
			gpuppur::tuple_for_each(s3.current_iterator, v);

			if(v.variance0 > 2048.0f)
			{
				return false;
			}

			if(v.variance1 > 2048.0f)
			{
				return false;
			}

			return true;
*/
			if
			(
				!s0.is_same_mtrl(s1)
				||
				!s0.is_same_mtrl(s2)
				||
				!s0.is_same_mtrl(s3)
				||
				!s1.is_same_mtrl(s2)
				||
				!s1.is_same_mtrl(s3)
				||
				!s2.is_same_mtrl(s3)
			)
			{
				return false;
			}

			if
			(
				!s0.is_same_normal(s1)
				||
				!s0.is_same_normal(s2)
				||
				!s0.is_same_normal(s3)
				||
				!s1.is_same_normal(s2)
				||
				!s1.is_same_normal(s3)
				||
				!s2.is_same_normal(s3)
			)
			{
				return false;
			}

			return true;
		}

			/**
			 *	This class should be local class of bool is_similar(...).
			 *	But that causes dumplicated class definition and link error.
			 */
		/*	class sum
			{
				typedef vector1ui16 type0;
				typedef vector4ui16 type1;

				sum():
					average0(static_cast<type0::element_type>(0)),
					average1(static_cast<type1::element_type>(0))
				{
				}

			public:

				inline void operator()(const vector1ui16* v)
				{
					this->average0 += *v/4;
				}

				inline void operator()(const vector4ui16* v)
				{
					this->average1 += *v/4;
				}

			private:
				const type0 get_avg0() const
				{
					return this->average0;
				}

				const type1 get_avg1() const
				{
					return this->average1;
				}

				type0 average0;
				type1 average1;

				friend
				bool gpu_buf::is_similar
				(
					const buf_iterator& s0,
					const buf_iterator& s1,
					const buf_iterator& s2,
					const buf_iterator& s3
				) const;

				friend class variance;
			};*/

			/**
			 *	This class should be local class of bool is_similar(...).
			 *	But that causes dumplicated class definition and link error.
			 */
		/*	class variance
			{
				variance(const sum& s):
					average0(s.get_avg0()),
					average1(s.get_avg1()),
					variance0(0),
					variance1(0)
				{
				}

			public:
				inline void operator()(const vector1ui16* v)
				{
					this->variance0 += (*v-this->average0).length2<float>();
				}

				inline void operator()(const vector4ui16* v)
				{
					this->variance1 += (*v-this->average1).length2<float>();
				}

			private:
				vector1ui16 average0;
				vector4ui16 average1;
				float variance0;
				float variance1;

				friend
				bool gpu_buf::is_similar
				(
					const buf_iterator& s0,
					const buf_iterator& s1,
					const buf_iterator& s2,
					const buf_iterator& s3
				) const;
			};
		*/
	};	//end of class gpu_buf

	template<class Implement>
	class g_buffer
	{
	public:

		typedef g_buffer<Implement>	this_type;

	private:

		const static std::size_t num_data = 2;//Implement::num_data;

		Implement& that()
		{
			return *reinterpret_cast<Implement*>(this);
		}

		template<int N>
		void impl_uninitialize(boost::mpl::int_<N> n)
		{
			(this->that().get_data(n)).uninitialize();

			this->impl_uninitialize((boost::mpl::int_<N+1>()));
		}

		void impl_uninitialize(boost::mpl::int_<this_type::num_data>)
		{
		}

	public:

		void uninitialize()
		{
			this->impl_uninitialize((boost::mpl::int_<0>()));
		}
	};

}	// end of namespace gpuppur

#endif

