#ifndef GPUPPUR_MATH_HPP
#define GPUPPUR_MATH_HPP

#include <gpuppur/3dmath/vectorNd.hpp>
#include <gpuppur/3dmath/line.hpp>
#include <gpuppur/3dmath/matrixRxC.hpp>

typedef gpuppur::VectorNd<float, 2>				vector2;
typedef gpuppur::VectorNd<float, 3>				vector3;
typedef gpuppur::VectorNd<float, 4>				vector4;
typedef gpuppur::VectorNd<unsigned short, 1>	vector1ui16;
typedef gpuppur::VectorNd<unsigned short, 2>	vector2ui16;
typedef gpuppur::VectorNd<unsigned short, 4>	vector4ui16;
typedef gpuppur::Line<vector3>					ray;
typedef gpuppur::matrixRxC<float, 3, 3, false>	matrix3x3;
typedef gpuppur::matrixRxC<float, 3, 4, false>	matrix3x4;
typedef gpuppur::matrixRxC<float, 4, 4, false>	matrix4x4;

const float M_PIf = 3.14159265358979323f;

#endif
