#ifndef NXPHYSICS_INSTANCE3D_HPP
#define NXPHYSICS_INSTANCE3D_HPP

/**
 *	@file
 *	@brief	PhysX Instance class
 *	@auther Tomohiro Matsumoto
 *
 *	@note	This file is only included from gpuppur/ppu/nxphysics.hpp.
 */

/**
 *	@brief	PhysX Instance class implement
 *	You can create instance of 3D object by calling some member function of class gpuppur::physics,
 *	and the instance of 3D object is rendered in scene.
 *	Such member function returns handle to instance, and you can control instance by calling member function of that.
 */
template<class UserDataType_>
class instance3d_implement
{
public:
template<class Parent, class Base>
class c : public Base
{
public:

	typedef Base						base;
	typedef NxActor						handled_type;
	typedef gpuppur::instance3d_virtual	virtual_type;
	typedef gpuppur::instance3d_generic generic_type;
	typedef physics<UserDataType_>		friend_type;
	typedef typename
	instance3d_implement<UserDataType_>::template c<Parent, Base>
										this_type;

private:

	handled_type& get_handled()
	{
		return reinterpret_cast<Parent*>(this)->get_handle();
	}

	const handled_type& get_handled() const
	{
		return reinterpret_cast<const Parent*>(this)->get_handle();
	}

public:

	/**	Set position of the instance
	 *
	 *	@param	new_pos	: [in]	new position of instance.
	 */
	void set_position(const vector3& new_pos)
	{
		this->get_handled().setGlobalPosition
		(
			*reinterpret_cast<const NxVec3*>(&new_pos)
		);
	}

	/** Get position of the instance
	 *
	 *	@return	Current position of the instace.
	 */
	vector3 get_position() const
	{
		return physics::to_vec3
		(
			this->get_handled().getGlobalPosition()
		);
	}

	void set_orientation(const matrix3x3& mat)
	{
		return
		this->get_handled().setGlobalOrientation
		(
			*reinterpret_cast<const NxMat33*>(&mat)
		);
	}

	const matrix4x4 get_trans_matrix() const
	{
		matrix4x4 ret;

		this->get_handled().getGlobalPose().getColumnMajor44
		(
			reinterpret_cast<NxF32*>(&ret)
		);

		return ret;
	}

	///Return associated user data with this object.
	UserDataType_& get_user_data()
	{
		return
		*reinterpret_cast<UserDataType_*>
		(
			this->get_handled().userData
		);
	}

	///Return associated user data with this object.
	const UserDataType_& get_user_data() const
	{
		return
		*reinterpret_cast<const UserDataType_*>
		(
			this->get_handled().userData
		);
	}


protected:
/*
	instance3d_implement(const NxActor& handler):
		base(handler)
	{
	}

	instance3d_implement(const boost::shared_ptr<NxActor>& handler):
		base(handler)
	{
	}
*/
	c()
	{
	}

	c(const this_type&)
	{
	}

	static void release(NxActor* actor)
	{
		if(!actor)
		{
			return;
		}

		if(physics<UserDataType_>::get_valid_actor_set().empty())
			return;

		typename physics<UserDataType_>::actor_set_per_scene::iterator i;
		for(i=physics<UserDataType_>::get_valid_actor_set().begin();
			i!=physics<UserDataType_>::get_valid_actor_set().end();
			++i)
		{
			if(i->second.find(actor) != i->second.end())
			{
				physics<UserDataType_>::uninitialize_actor(actor);
				actor->getScene().releaseActor(*actor);
				i->second.erase(actor);
			}
		}
	}

	friend class physics<UserDataType_>;
};
};

#endif
