#ifndef NXPHYSICS_MESH_HPP
#define NXPHYSICS_MESH_HPP

/**
 * This file is only included from gpuppur/ppu/nxphysics.hpp.
 **/

template<class Parent, class Base>
class mesh_implement : public  Base
{
public:

	typedef Base						base;
	typedef NxTriangleMesh				handled_type;
	typedef gpuppur::mesh_virtual		virtual_type;
	typedef gpuppur::mesh_generic		generic_type;
	typedef	physics_implement			friend_type;

private:

	handled_type& get_handled()
	{
		return reinterpret_cast<Parent*>(this)->get_handle();
	}

	const handled_type& get_handled() const
	{
		return reinterpret_cast<const Parent*>(this)->get_handle();
	}

public:

	void get_mesh_data
	(
		std::vector<vector3>&			vertices,
		std::vector<vector3>&			normals,
		std::vector<vector2>&			uv0_coords,
		gpuppur::index_buffer&			indices
	) const
	{
		assert(this->get_handled().getFormat(0, NX_ARRAY_VERTICES) == NX_FORMAT_FLOAT);
		assert(this->get_handled().getFormat(0, NX_ARRAY_NORMALS) == NX_FORMAT_FLOAT);
		assert(this->get_handled().getFormat(0, NX_ARRAY_TRIANGLES) == NX_FORMAT_INT);

		NxU32 num_vertices = this->get_handled().getCount(0, NX_ARRAY_VERTICES);
		NxU32 num_normals = this->get_handled().getCount(0, NX_ARRAY_NORMALS);
		NxU32 num_triangles = this->get_handled().getCount(0, NX_ARRAY_TRIANGLES);

		assert(num_vertices == num_normals);

		vertices.resize(num_vertices);
		normals.resize(num_normals);
		uv0_coords.clear();					//uv coordinate is not supported.

		NxFlexiCopy
		(
			this->get_handled().getBase(0, NX_ARRAY_VERTICES),
			&vertices[0],
			num_vertices,
			sizeof(NxVec3),
			this->get_handled().getStride(0, NX_ARRAY_VERTICES)
		);

		NxFlexiCopy
		(
			this->get_handled().getBase(0, NX_ARRAY_NORMALS),
			&normals[0],
			num_normals,
			sizeof(NxVec3),
			this->get_handled().getStride(0, NX_ARRAY_NORMALS)
		);

		NxU32	stride = this->get_handled().getStride(0, NX_ARRAY_TRIANGLES);
/*delete
		const char* base = reinterpret_cast<const char*>
		(
			this->get_handled().getBase(0, NX_ARRAY_TRIANGLES)
		);
		std::size_t cnt = 0;
		for
		(
			const char* i = base;
			i != base + stride*num_triangles;
			i+=stride
		)
		{
			for(std::size_t j=0; j<3; ++j)
			{
				indices[cnt++]
				=
				*reinterpret_cast<const unsigned short*>(i+j*sizeof(NxU32));
			}
		}
*/
		indices.load_data
		(
			num_vertices,
			this->get_handled().getBase(0, NX_ARRAY_TRIANGLES),
			boost::type<unsigned int>(),
			stride,
			num_triangles*3
		);
	}

protected:
/*
	mesh_implement(const handled_type& handler):
		base(handler)
	{
	}


	mesh_implement(const boost::shared_ptr<handled_type>& handler):
		base(handler)
	{
	}
*/
	mesh_implement()
	{
	}

	static void release(handled_type* mesh_handle)
	{
		assert(mesh_handle);
		//No instance3d must not have this mesh.
		assert(mesh_handle->getReferenceCount() == 0);

		for
		(
			physics_implement::mesh_set_per_physics::iterator i
			=
			physics_implement::get_valid_mesh_set().begin();
			i!=physics_implement::get_valid_mesh_set().end();
			++i
		)
		{
			if(i->second.erase(mesh_handle))
			{
				physics_implement::nxphysics_sdk	physics_sdk;
				physics_sdk.initialize();
				physics_sdk->releaseTriangleMesh(*mesh_handle);
			}
		}
	}
};

#endif
