#ifndef GPUPPUR_TEXTURE_HPP

#include <gpuppur/texbuf/gl_tex_buf.hpp>
#include <gpuppur/texbuf/dx_tex_buf.hpp>
#include "handler.hpp"
#include "handle_generic.hpp"

namespace gpuppur
{

template
<
	class TextureImplement,
	class Owner
>
struct texture_implement 
{
template<class Parent, class Base>
class c : public Base
{
public:

	typedef
	gpuppur::texture_implement<TextureImplement, Owner>
													parent_type;
	typedef typename parent_type::template c<Parent, Base>
													this_type;
	typedef typename TextureImplement::group_type	group_type;

	typedef Base									base;
	typedef TextureImplement						handled_type;
	typedef gpuppur::texture_virtual<group_type>	virtual_type;
	typedef gpuppur::texture_generic<group_type>	generic_type;
	typedef Owner									friend_type;

private:

	handled_type& get_handled()
	{
		return reinterpret_cast<Parent*>(this)->get_handle();
	}

	const handled_type& get_handled() const
	{
		return reinterpret_cast<const Parent*>(this)->get_handle();
	}

public:

	bool lock_for_write()
	{
		assert(&this->get_handled());
		return this->get_handled().lock_for_write();
	}

	bool unlock()
	{
		assert(&this->get_handled());
		return this->get_handled().unlock();
	}

	void set(const group_type& vec)
	{
		assert(&this->get_handled());
		return this->get_handled().set(vec);
	}

	group_type* get_buf_ptr()
	{
		assert(&this->get_handled());
		return this->get_handled().get_buf_ptr();
	}

protected:

	static void release(handled_type* texture_handle)
	{
		delete texture_handle;
	}

	c()
	{
	}

	c(const this_type&)
	{
	}
};

	typedef typename gpuppur::handler_tmpl<c>::c_static		texture_static;
	typedef typename gpuppur::handler_tmpl<c>::c_tmp		texture_tmp;
	typedef typename gpuppur::handler_tmpl<c>::c_alone		texture_alone;
};

}	//end of namespace gpuppur

#endif
