#ifndef GPUPPURUT_GDXUT_HPP
#define GPUPPURUT_GDXUT_HPP

#ifndef _MSC_VER
	namespace gpuppur
	{
		struct gdxut;
	}
#else

#include <gpuppur/utility/begin_suppress_warnings_from_others_code.hpp>

#include <string>
#include <d3d9.h>
#include <d3dx9.h>
#include <D3dx9effect.h>
#include <dxerr9.h>
#include <D3dx9shape.h>
#include <d3dx9math.h>
#include <windows.h>
#include <tchar.h>

#include <gpuppur/utility/end_suppress_warnings.hpp>


#include <gpuppur/gpuppurut/gpuppurut_base.hpp>

namespace gpuppur
{

struct gdxut : public gpuppurut
{
public:

#ifdef _WIN32
#ifdef _WINDOWS
	/**
	 *	This function must be called before you use this class.
	 */
	static void		global_initialize()
	{
		//This function is not used yet.
		//Should all window share same IDirect3D9?
	}

#endif
#ifdef UNICODE
	/**
	 *	This function must be called before you use this class.
	 */
	static void		global_initialize(int* /*argc*/, TCHAR** /*argv*/)
	{
		//This function is not used yet.
		//Should this function parse argv like glut?
	}

#endif
#endif	// end of #ifdef _WIN32

	/**
	 *	Overload of global_initialize
	 */
	static void global_initialize(int*, char**)
	{
	}

	/**
	 *	Receive message send to all glut windows, and invoke callback functions.
	 */
	static void		handle_event();

	gdxut();
	~gdxut();

	ReturnCode		initialize(int width, int height, const std::string& title)
	{
		return this->tmpl_initialize(width, height, title);
	}

	ReturnCode		initialize(int width, int height, const std::wstring& title)
	{
		return this->tmpl_initialize(width, height, title);
	}

	void			uninitialize();
	ReturnCode		set_window(HWND hWndFocus);

	// xgnhŌĂяo֐BOől͂WndProcŌĂяo悤ɂĂ͂B
	// ̊֐DefWindowProcĂŁA̖߂lԂ܂B
	LRESULT			wnd_proc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );


	// Direct3Dł̕`揈Jn܂B
	// Begin drawing in Direct3D.
	// If is_clear==false, this function doesnt clear color buffer and depth buffer.
	bool			begin_scene(bool is_clear=true);
	// Direct3Dł̕`揈IAʂ֏o͂܂B
	// End drawing in Direct3D, and output to display.
	ReturnCode		end_scene();

	void			redraw();

	bool			set_fullscreen(bool is_full);
	bool			get_is_fullscreen() const
	{
		return this->isFullscreen;
	}

	int				get_width() const
	{
		return this->WindowRect.right - this->WindowRect.left;
	}

	int				get_height() const
	{
		return this->WindowRect.bottom - this->WindowRect.top;
	}

	/// InvisibleԂƂAVisibleԂ悤ɂȂ̂҂ԂɕKHandleEvent()ĂԂƁB
	ReturnCode		get_is_visible() const;

	void			set_clear_color(int r, int g, int b)
	{
		this->clear_color[0] = r;
		this->clear_color[1] = g;
		this->clear_color[2] = b;
	}

	IDirect3DDevice9*	get_device() const
	{
		assert(this->D3DDevice != NULL);

		return this->D3DDevice;
	}

	const HWND			get_hWnd() const
	{
		return this->hWnd;
	}

	/*
	 * Return 3D graphics context. Some directx method require d3d device.
	 */
	void*		get_context() const
	{
		return this->get_device();
	}

protected:

	template<typename _char>
	ReturnCode		tmpl_initialize(int width, int height, const std::basic_string<_char>& title)
	{
		this->uninitialize();

		bool ret = this->create_dx_Window(title, width, height);

		if(!ret)
		{
			this->uninitialize();
			return gdxut::ReturnCode::FailCreatingWindow;
		}

		this->is_user_init_failed = false;

		ReturnCode retCode = this->create_device(width, height);

		if(retCode != gpuppurut::ReturnCode::OK)
		{
			this->uninitialize();
		}

		if(this->is_user_init_failed)
		{
			return gpuppurut::ReturnCode::FailedUserInit;
		}

		return retCode;
	}

	// [UCreateWindowő邩SetWindowŎȎݒ肷B
	bool			create_dx_Window(const std::string& title, int width, int height);
	bool			create_dx_Window(const std::wstring& title, int width, int height);
	ReturnCode		create_device( int width = 640, int height = 480,
							bool is_full = false, UINT AdapterOrdinal = D3DADAPTER_DEFAULT );

	bool			set_hWnd(HWND hWnd);

	/// Check if window size was changed, and if so, handle window size change.
	void			check_window_size_change();
	/// Take changed window size, and handle window size change.
	HRESULT			handle_window_size_change(int width, int height, bool need_reset = true);
	HRESULT			reset(bool needed_resize = true);
	bool			set_default_present_param(bool is_full, UINT adapter, int width=-1, int height=-1);

	// DeviceLostԂɂȂAResetOɎsB
	HRESULT			on_lost_device();



	IDirect3D9*							D3D;
	IDirect3DDevice9*					D3DDevice;
	HWND								hWnd;
	RECT								WindowRect;
	int									clear_color[3];
	bool								isLostDevice;
	bool								isFullscreen;
	D3DPRESENT_PARAMETERS				D3DPresentParam;
	bool								on_resetting;
	bool								is_user_init_failed;
};

}	//end of namespace gpuppur

#endif
#endif
