#ifndef GPUPPURUT_GGLUT_HPP
#define GPUPPURUT_GGLUT_HPP

#if defined(_MSC_VER) || defined(__CYGWIN__) || defined(__MINGW32__)
#   define NOMINMAX
#   include <windows.h>
#endif

#include <GL/gl.h>
#include <GL/glu.h>
#include <gpuppur/gpuppurut/gpuppurut_base.hpp>

namespace gpuppur
{

class gglut : public gpuppurut
{
public:

	/**
	 *	This function must be called before you use this class.
	 */
#ifdef _WIN32
#ifdef _WINDOWS
	static void global_initialize();
#endif
#ifdef UNICODE
	static void global_initialize(int* pargc, TCHAR** argv);
#endif
#endif	// end of #ifdef _WIN32

	static void global_initialize(int* pargc, char** argv);

	/**
	 *	Receive message send to all glut windows, and invoke callback functions.
	 */
	static void handle_event();

	gglut();
	~gglut();

	gpuppurut::ReturnCode		initialize(int width, int height, const std::string& title)
	{
		return this->tmpl_initialize(width, height, title);
	}

	gpuppurut::ReturnCode		initialize(int width, int height, const std::wstring& title)
	{
		return this->tmpl_initialize(width, height, title);
	}

	void		uninitialize();

	/// `揈Jn܂B
	/// Begin drawing.
	bool		begin_scene(bool is_clear=true);
	/// `揈IAʂ֏o͂܂B
	/// End drawing and output to display.
	gpuppurut::ReturnCode	end_scene();

	void		redraw();

	bool		set_fullscreen(bool isFull);
	bool		get_is_fullscreen() const
	{
		return this->isFullscreen;
	}

	int			get_width() const;
	int			get_height() const;

	/// You have to call handle_event() to update return value of isVisible()
	gpuppurut::ReturnCode	get_is_visible() const
	{
		return this->isVisible ? ReturnCode::Visible : ReturnCode::Invisible;
	}

	/*
	 * Return 3D graphics context, but opengl functions doesn't require such a thing.
	 */
	void*		get_context() const
	{
		return NULL;
	}

protected:

	template<typename _char>
	gpuppurut::ReturnCode	tmpl_initialize(int width, int height, const std::basic_string<_char>& title)
	{
		assert(gglut::is_global_initialized || "you have to call static gglut::global_initialize()!"+1 == NULL);

		this->uninitialize();

		this->windowID = createWindow(width, height, title);

		//OpenGLUT̃hLgɂcreateWindowŎs0Ԃ炵A\[XR[hł͂ȂĂȂ悤B
		if(this->windowID == 0)
		{
			gpuppurut::ReturnCode::FailCreatingWindow;
		}

		gpuppurut::ReturnCode ret = this->init();
		if(ret != gpuppurut::ReturnCode::OK)
		{
			return ret;
		}

		this->resizeFunc(*this, width, height);

		return gpuppurut::ReturnCode::OK;
	}

	static int		createWindow(int width, int height, const std::string& title);
	static int		createWindow(int width, int height, const std::wstring& title);

	///callback functions for glut
	static void		close();
	static void		display();
	static void		keybord(unsigned char key, int x, int y);
	static void		special(int key, int x, int y);
	static void		keybordUp(unsigned char key, int x, int y);
	static void		specialUp(int key, int x, int y);
	static void		motion(int, int);
	static void		mouse(int, int, int, int);
	static void		passiveMotion(int, int);
	static void		windowStatus(int state);
	static void		reshape(int, int);

	/***
	 *	Used to get pointer to gglut instance in callback function of that's window.
	 */
	static gglut*			getpGGLUT();

	static bool				is_global_initialized;

	gpuppurut::ReturnCode	init();


	int		windowID;
	bool	isFullscreen;
	bool	isVisible;
};

}	// end of namespace gpuppur

#endif

