#ifndef GPUPPUR_RECTANGLE_DIRECTX_HPP
#define GPUPPUR_RECTANGLE_DIRECTX_HPP

/**
 *	@file	
 *	@brief	Rectangle class implemented with directx9.
 *	@author	Tomohiro Matsumoto
 */


#ifndef D3D_SDK_VERSION

namespace gpuppur
{
	class rectangle_directx;
}

#else

#include <gpuppur/error_manage/error_report_dx.hpp>

namespace gpuppur
{

class rectangle_directx
{
public:
	rectangle_directx():
		vertex_buf(NULL)
	{
	}

	~rectangle_directx()
	{
		this->uninitialize();
	}

	void uninitialize()
	{
		if(this->vertex_buf == 0)
		{
			return;
		}

		SAFE_RELEASE(vertex_buf);
	}

	bool initialize(IDirect3DDevice9*  context)
	{
		assert(context);

		const float data[] =
		{
			-1.0f, 1.0f, 0.0f,	0.0f, 1.0f,
			1.0f, 1.0f, 0.0f,	1.0f, 1.0f,
			-1.0f, -1.0f, 0.0f,	0.0f, 0.0f,
			1.0f, -1.0f, 0.0f,	1.0f, 0.0f
		};

		B_RET
		(
			context->CreateVertexBuffer
			(
				sizeof(float)*5*4,
				D3DUSAGE_WRITEONLY,
				D3DFVF_XYZ | D3DFVF_TEX1,
				D3DPOOL_DEFAULT,
				&this->vertex_buf,
				NULL
			)
		);

		void* pdata;

		B_RET( this->vertex_buf->Lock(0, 0, &pdata, 0) );
		memcpy(pdata, data, sizeof(float)*5*4);
		B_RET( this->vertex_buf->Unlock() );

		return true;
	}

	void set_state(IDirect3DDevice9*  context)
	{
		assert(context);
		assert(this->vertex_buf);

		V(context->SetFVF(D3DFVF_XYZ | D3DFVF_TEX1));
		V(context->SetStreamSource(0, this->vertex_buf, 0, sizeof(float)*5));
	}

	void draw(IDirect3DDevice9*  context)
	{
		assert(context);
		assert(this->vertex_buf);

		V(context->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, 2));
	}

	void set_viewport(int x, int y, int width, int height, IDirect3DDevice9* context)
	{
		assert(context);

		D3DVIEWPORT9 vp = {x, y, width, height, 0.0f, 1.0f};
		V(context->SetViewport(&vp));
	}

protected:

	IDirect3DVertexBuffer9*	vertex_buf;
};


}	//end of namespace gpuppur

#endif
#endif
