#ifndef GPUPPUR_RECTANGLE_OPENGL_HPP
#define GPUPPUR_RECTANGLE_OPENGL_HPP

/**
 *	@file	
 *	@brief	Rectangle class implemented with OpenGL.
 *	@author	Tomohiro Matsumoto
 */

#include <boost/mpl/void.hpp>

namespace gpuppur
{

class rectangle_opengl
{
public:
	rectangle_opengl():
		state_list(0),
		draw_list(0)
	{
	}

	~rectangle_opengl()
	{
		this->uninitialize();
	}

	void uninitialize()
	{
		if(this->state_list == 0)
		{
			return;
		}

		glDeleteLists(this->state_list, 2);
		this->state_list = this->draw_list = 0;
	}

	bool initialize(boost::mpl::void_)
	{
		this->state_list = glGenLists(2);
		if(this->state_list == 0)
		{
			return false;
		}

		this->draw_list = this->state_list + 1;

		glNewList(this->state_list, GL_COMPILE);
			glMatrixMode(GL_PROJECTION);
			glLoadIdentity();
			glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();
		glEndList();

		this->set_texture_size(1.0f, 1.0f);

		return true;
	}

	void set_state(boost::mpl::void_)
	{
		assert(this->state_list);
		glCallList(this->state_list);
	}

	void draw(boost::mpl::void_)
	{
		assert(this->draw_list);
		glCallList(this->draw_list);
	}

	void set_viewport(int x, int y, int width, int height, boost::mpl::void_)
	{
		glViewport(x, y, width, height);
	}

	void set_texture_size(float width, float height)
	{
		glNewList(this->draw_list, GL_COMPILE);
			glEnable(GL_DEPTH_TEST);
			glEnable(GL_LIGHTING);
			glEnable(GL_LIGHT0);
		//	glEnable(GL_TEXTURE_RECTANGLE_NV);
			glEnable(GL_TEXTURE_2D);

			float& w = width;
			float& h = height;
			glBegin(GL_QUADS);
				glTexCoord2f(w, h);
				glVertex2f(1.0f, 1.0f);
				glTexCoord2f(0.0f, h);
				glVertex2f(-1.0f, 1.0f);
				glTexCoord2f(0.0f, 0.0f);
				glVertex2f(-1.0f, -1.0f);
				glTexCoord2f(w, 0.0f);
				glVertex2f(1.0f, -1.0f);
			glEnd();

			glDisable(GL_DEPTH_TEST);
			glDisable(GL_LIGHTING);
			glDisable(GL_LIGHT0);
		//	glDisable(GL_TEXTURE_RECTANGLE_NV);
			glDisable(GL_TEXTURE_2D);
		glEndList();
	}

protected:

	GLuint		state_list;
	GLuint		draw_list;
};

}	// end of namespace gpuppur

#endif
