#ifndef UTILITY_FRAME_PER_SECOND_HPP
#define UTILITY_FRAME_PER_SECOND_HPP

/**
 *	@file	
 *	@brief	Class for count FPS(Frame per second).
 *	@author	Tomohiro Matsumoto
 */

#include "begin_suppress_warnings_from_others_code.hpp"
#include <boost/date_time/posix_time/posix_time.hpp>
#include <iostream>
#include "end_suppress_warnings.hpp"

namespace gpuppur
{

class frame_per_second
{
	unsigned int	c;
	float			spf;
	float			fps;
	long			sampling_time;	//msec

	frame_per_second():
		c(0), spf(1.0f/60.0f), fps(60.0f), sampling_time(1000L)
	{
	}

	static frame_per_second& core()
	{
		static frame_per_second instance;

		return instance;
	}

public:

	static void probe()
	{
		static boost::posix_time::ptime begin = boost::posix_time::second_clock::local_time();
		boost::posix_time::ptime end = boost::posix_time::second_clock::local_time();
		boost::posix_time::time_duration diff = end - begin;

		if(diff.total_milliseconds() > core().sampling_time)
		{
			core().fps = core().c/(diff.total_milliseconds()/1000.0f);
			core().spf = diff.total_milliseconds()/1000.0f/core().c;
			std::cout
			<< "fps:" << core().fps
			<< "(mspf:" << core().spf*1000.0f << ")"
			<< std::endl;

			begin = end;

			if(core().c<100)
			{
				if(core().sampling_time < 5000L)
					core().sampling_time += static_cast<long>(1000/(core().c+1));
			}else if(core().c >= 200)
			{
				if(core().sampling_time >= 1000L)
				{
					core().sampling_time -= 50L;
				}
			}

			core().c = 0;
		}
		core().c++;
	}

	static float get_fps()
	{
		return core().fps;
	}

	static float get_spf()
	{
		return core().spf;
	}
};

}	//end of namespace gpuppur

#endif
