#ifndef UTILITY_IMAGE_IO
#define UTILITY_IMAGE_IO

/**
 *	@file	
 *	@brief	Class for read image file.
 *	@author	Tomohiro Matsumoto
 */

extern "C"
{
#include <png.h>
}
#include <cstdio>
#include <string>
#include <iostream>
#include <vector>

#include <gpuppur/3dmath/vectorNd.hpp>

namespace gpuppur
{

class image
{
	typedef unsigned char		byte;
	typedef std::vector<byte>	data;
	typedef data::iterator		data_itr;
	
	static int read_chunk_callback
	(
		png_structp ptr,
    	png_unknown_chunkp chunk
	)
	{
	/*	png_byte name[5];
		png_byte *data;
		png_size_t size;*/

		/* Note that libpng has already taken care of
		   the CRC handling */

		/* put your code here.  Return one of the
following: */

	//	return (-n); /* chunk had an error */
		return (0); /* did not recognize */
	//	return (n); /* success */
	}

public:

	bool load_image(const std::string& filename)
	{
		FILE* fp = fopen(filename.c_str(), "rb");
		if(!fp)
		{
			std::cerr << filename << " is not found!" << std::endl;
			return false;
		}

		const static int header_size = 8;
		byte header[header_size];
		fread((void*)header, 1, header_size, fp);
		if(png_sig_cmp(header, 0, header_size))
		{
			std::cerr << filename << " is not PNG format file!" << std::endl;
			return false;
		}

		png_structp png_ptr =
		png_create_read_struct
		(
			PNG_LIBPNG_VER_STRING,
			/*(png_voidp)user_error_ptr*/NULL,
			/*user_error_fn*/NULL, /*user_warning_fn*/NULL
		);
		if (!png_ptr)
			return false;

		png_infop info_ptr = png_create_info_struct(png_ptr);
		if (!info_ptr)
		{
			png_destroy_read_struct
			(
				&png_ptr,
				(png_infopp)NULL, (png_infopp)NULL
			);

			return false;
		}

		png_infop end_info = png_create_info_struct(png_ptr);
		if (!end_info)
		{
			png_destroy_read_struct
			(
				&png_ptr, &info_ptr,
				(png_infopp)NULL
			);

			return false;
		}

		png_init_io(png_ptr, fp);
		png_set_sig_bytes(png_ptr, header_size);

	//	png_set_read_user_chunk_fn(png_ptr, NULL, &image::read_chunk_callback);

		png_read_info(png_ptr, info_ptr);

		unsigned long width, height;
		int bit_depth, color_type, interlace_type;
		png_get_IHDR
		(
			png_ptr, info_ptr,
			&width, &height,
			&bit_depth,
			&color_type,
			&interlace_type,
			NULL, NULL
		);

		int rowbytes = png_get_rowbytes(png_ptr, info_ptr);

		//currently, only support 24bit color
		assert(static_cast<unsigned long>(rowbytes) == 3*height);

		this->img_data.resize(rowbytes*height);
		std::vector<byte*> row_ptr(height);
		for(std::size_t i=0; i<height; ++i)
		{
			row_ptr[i] = &img_data[rowbytes*i];
		}

		png_read_image(png_ptr, &row_ptr[0]);
		png_read_end(png_ptr, NULL);
		png_destroy_read_struct(&png_ptr, &info_ptr, NULL);

		fclose(fp);
		this->img_itr = this->img_data.begin();
		this->width = width;
		this->height = height;

		return true;
	}

	const VectorNd<float, 4> get_pixel()
	{
		assert(img_itr != this->img_data.end());

		const data_itr itr = this->img_itr;
		this->img_itr += 3;

		return VectorNd<float, 4>
		(
			*itr/255.0f,
			*(itr+1)/255.0f,
			*(itr+2)/255.0f
		);
	}

	std::size_t get_width() const
	{
		return this->width;
	}

	std::size_t get_height() const
	{
		return this->height;
	}

private:

	data		img_data;
	data_itr	img_itr;
	std::size_t	width, height;
};

}	//end of namespace gpuppur

#endif
