/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.internet.MimeUtility;

public class MimeMessage
extends Message
implements MimePart {
    protected DataHandler dh;
    protected byte[] content;
    protected InputStream contentStream;
    protected InternetHeaders headers;
    protected Flags flags;
    protected boolean modified;
    protected boolean saved;
    private final MailDateFormat dateFormat = new MailDateFormat();

    public MimeMessage(Session session) {
        super(session);
        this.headers = new InternetHeaders();
        this.flags = new Flags();
        this.modified = true;
    }

    public MimeMessage(Session session, InputStream in) throws MessagingException {
        super(session);
        this.parse(in);
    }

    public MimeMessage(MimeMessage message) throws MessagingException {
        super(message.session);
        throw new UnsupportedOperationException();
    }

    protected MimeMessage(Folder folder, int number) {
        super(folder, number);
        this.headers = new InternetHeaders();
        this.flags = new Flags();
        this.modified = true;
    }

    protected MimeMessage(Folder folder, InputStream in, int number) throws MessagingException {
        super(folder, number);
        this.parse(in);
    }

    protected MimeMessage(Folder folder, InternetHeaders headers, byte[] content, int number) throws MessagingException {
        super(folder, number);
        this.headers = headers;
        this.content = content;
        this.modified = true;
    }

    protected void parse(InputStream in) throws MessagingException {
        in = new BufferedInputStream(in);
        this.headers = new InternetHeaders(in);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int count;
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer, 0, 1024)) != -1) {
                baos.write(buffer, 0, count);
            }
        }
        catch (Exception e) {
            throw new MessagingException(e.toString(), e);
        }
        this.content = baos.toByteArray();
    }

    public Address[] getFrom() throws MessagingException {
        boolean strict = this.isStrictAddressing();
        Address[] result = this.getHeaderAsAddresses("From", strict);
        if (result == null) {
            result = this.getHeaderAsAddresses("Sender", strict);
        }
        return result;
    }

    public void setFrom(Address address) throws MessagingException {
        this.setHeader("From", address);
    }

    public void setFrom() throws MessagingException {
        this.setFrom(InternetAddress.getLocalAddress(this.session));
    }

    public void addFrom(Address[] addresses) throws MessagingException {
        this.addHeader("From", addresses);
    }

    public Address getSender() throws MessagingException {
        InternetAddress[] addrs = this.getHeaderAsAddresses("Sender", this.isStrictAddressing());
        return addrs.length > 0 ? addrs[0] : null;
    }

    public void setSender(Address address) throws MessagingException {
        this.setHeader("Sender", address);
    }

    public Address[] getRecipients(Message.RecipientType type) throws MessagingException {
        return this.getHeaderAsAddresses(this.getHeaderForRecipientType(type), this.isStrictAddressing());
    }

    public Address[] getAllRecipients() throws MessagingException {
        ArrayList recipients = new ArrayList();
        this.addRecipientsToList(recipients, RecipientType.TO);
        this.addRecipientsToList(recipients, RecipientType.CC);
        this.addRecipientsToList(recipients, RecipientType.BCC);
        this.addRecipientsToList(recipients, RecipientType.NEWSGROUPS);
        return recipients.toArray(new Address[recipients.size()]);
    }

    private void addRecipientsToList(List list, Message.RecipientType type) throws MessagingException {
        InternetAddress[] recipients = this.getHeaderAsAddresses(this.getHeaderForRecipientType(type), this.isStrictAddressing());
        if (recipients != null) {
            list.addAll(Arrays.asList(recipients));
        }
    }

    public void setRecipients(Message.RecipientType type, Address[] addresses) throws MessagingException {
        this.setHeader(this.getHeaderForRecipientType(type), addresses);
    }

    public void setRecipients(Message.RecipientType type, String address) throws MessagingException {
        this.setHeader(this.getHeaderForRecipientType(type), address);
    }

    public void addRecipients(Message.RecipientType type, Address[] address) throws MessagingException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    public void addRecipients(Message.RecipientType type, String address) throws MessagingException {
        this.addHeader(this.getHeaderForRecipientType(type), address);
    }

    public Address[] getReplyTo() throws MessagingException {
        return this.getHeaderAsAddresses("Reply-To", this.isStrictAddressing());
    }

    public void setReplyTo(Address[] address) throws MessagingException {
        this.setHeader("Reply-To", address);
    }

    public String getSubject() throws MessagingException {
        String subject = this.getSingleHeader("Subject");
        if (subject == null) {
            return null;
        }
        try {
            return MimeUtility.decodeText(subject);
        }
        catch (UnsupportedEncodingException e) {
            return subject;
        }
    }

    public void setSubject(String subject) throws MessagingException {
        this.setHeader("Subject", subject);
    }

    public void setSubject(String subject, String charset) throws MessagingException {
        try {
            this.setHeader("Subject", MimeUtility.encodeText(subject, charset, null));
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }

    public Date getSentDate() throws MessagingException {
        String value = this.getSingleHeader("Date");
        if (value == null) {
            return null;
        }
        try {
            return this.dateFormat.parse(value);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setSentDate(Date sent) throws MessagingException {
        if (sent == null) {
            this.removeHeader("Date");
        } else {
            this.setHeader("Date", this.dateFormat.format(sent));
        }
    }

    public Date getReceivedDate() throws MessagingException {
        return null;
    }

    public int getSize() throws MessagingException {
        if (this.content != null) {
            return this.content.length;
        }
        return -1;
    }

    public int getLineCount() throws MessagingException {
        return -1;
    }

    public String getContentType() throws MessagingException {
        String value = this.getSingleHeader("Content-Type");
        if (value == null) {
            value = "text/plain";
        }
        return value;
    }

    public boolean isMimeType(String type) throws MessagingException {
        return new ContentType(this.getContentType()).match(type);
    }

    public String getDisposition() throws MessagingException {
        return this.getSingleHeader("Content-Disposition");
    }

    public void setDisposition(String disposition) throws MessagingException {
        this.setHeader("Content-Disposition", disposition);
    }

    public String getEncoding() throws MessagingException {
        return this.getSingleHeader("Content-Transfer-Encoding");
    }

    public String getContentID() throws MessagingException {
        return this.getSingleHeader("Content-ID");
    }

    public void setContentID(String cid) throws MessagingException {
        this.setHeader("Content-ID", cid);
    }

    public String getContentMD5() throws MessagingException {
        return this.getSingleHeader("Content-MD5");
    }

    public void setContentMD5(String md5) throws MessagingException {
        this.setHeader("Content-MD5", md5);
    }

    public String getDescription() throws MessagingException {
        return this.getSingleHeader("Content-Description");
    }

    public void setDescription(String description) throws MessagingException {
        this.setHeader("Content-Description", description);
    }

    public void setDescription(String description, String charset) throws MessagingException {
        this.setHeader("Content-Description", description);
    }

    public String[] getContentLanguage() throws MessagingException {
        return this.getHeader("Content-Language");
    }

    public void setContentLanguage(String[] languages) throws MessagingException {
        if (languages == null || languages.length == 0) {
            this.removeHeader("Content-Language");
        } else if (languages.length == 1) {
            this.setHeader("Content-Language", languages[0]);
        } else {
            StringBuffer buf = new StringBuffer(languages.length * 20);
            buf.append(languages[0]);
            for (int i = 1; i < languages.length; ++i) {
                buf.append(',').append(languages[i]);
            }
            this.setHeader("Content-Language", buf.toString());
        }
    }

    public String getMessageID() throws MessagingException {
        return this.getSingleHeader("Message-ID");
    }

    public String getFileName() throws MessagingException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    public void setFileName(String name) throws MessagingException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    public InputStream getInputStream() throws MessagingException, IOException {
        return this.getDataHandler().getInputStream();
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        throw new MessagingException("No content");
    }

    public InputStream getRawInputStream() throws MessagingException {
        return this.getContentStream();
    }

    public synchronized DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            this.dh = new DataHandler(new MimePartDataSource(this));
        }
        return this.dh;
    }

    public Object getContent() throws MessagingException, IOException {
        return this.getDataHandler().getContent();
    }

    public void setDataHandler(DataHandler handler) throws MessagingException {
        this.dh = handler;
    }

    public void setContent(Object content, String type) throws MessagingException {
        this.setDataHandler(new DataHandler(content, type));
    }

    public void setText(String text) throws MessagingException {
        this.setText(text, MimeUtility.getDefaultJavaCharset());
    }

    public void setText(String text, String charset) throws MessagingException {
        this.setContent(text, "text/plain; charset=" + charset);
    }

    public void setContent(Multipart part) throws MessagingException {
        this.setDataHandler(new DataHandler(part, part.getContentType()));
        part.setParent(this);
    }

    public Message reply(boolean replyToAll) throws MessagingException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    public void writeTo(OutputStream out) throws MessagingException, IOException {
        this.writeTo(out, null);
    }

    public void writeTo(OutputStream out, String[] ignoreHeaders) throws MessagingException, IOException {
        if (!this.saved) {
            this.saveChanges();
        }
        this.headers.writeTo(out, ignoreHeaders);
        out.write(13);
        out.write(10);
        if (this.modified) {
            this.dh.writeTo(MimeUtility.encode(out, this.getEncoding()));
        } else {
            out.write(this.content);
        }
    }

    public String[] getHeader(String name) throws MessagingException {
        return this.headers.getHeader(name);
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        return this.headers.getHeader(name, delimiter);
    }

    public void setHeader(String name, String value) throws MessagingException {
        this.headers.setHeader(name, value);
    }

    public void addHeader(String name, String value) throws MessagingException {
        this.headers.addHeader(name, value);
    }

    public void removeHeader(String name) throws MessagingException {
        this.headers.removeHeader(name);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] names) throws MessagingException {
        return this.headers.getMatchingHeaders(names);
    }

    public Enumeration getNonMatchingHeaders(String[] names) throws MessagingException {
        return this.headers.getNonMatchingHeaders(names);
    }

    public void addHeaderLine(String line) throws MessagingException {
        this.headers.addHeaderLine(line);
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] names) throws MessagingException {
        return this.headers.getMatchingHeaderLines(names);
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) throws MessagingException {
        return this.headers.getNonMatchingHeaderLines(names);
    }

    public synchronized Flags getFlags() throws MessagingException {
        return (Flags)this.flags.clone();
    }

    public synchronized boolean isSet(Flags.Flag flag) throws MessagingException {
        return this.flags.contains(flag);
    }

    public synchronized void setFlags(Flags flags, boolean set) throws MessagingException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    public void saveChanges() throws MessagingException {
        this.updateHeaders();
    }

    protected void updateHeaders() throws MessagingException {
    }

    protected InternetHeaders createInternetHeaders(InputStream in) throws MessagingException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    private InternetAddress[] getHeaderAsAddresses(String header, boolean strict) throws MessagingException {
        return this.headers.getHeaderAsAddresses(header, strict);
    }

    private boolean isStrictAddressing() {
        String property = this.session.getProperty("mail.mime.address.strict");
        return property == null ? true : Boolean.valueOf(property);
    }

    private void setHeader(String header, Address address) {
        if (address == null) {
            this.headers.removeHeader(header);
        } else {
            this.headers.setHeader(header, address.toString());
        }
    }

    private void setHeader(String header, Address[] addresses) {
        if (addresses == null) {
            this.headers.removeHeader(header);
        } else {
            this.headers.setHeader(header, addresses);
        }
    }

    private void addHeader(String header, Address[] addresses) {
        this.headers.addHeader(header, InternetAddress.toString(addresses));
    }

    private String getHeaderForRecipientType(Message.RecipientType type) throws MessagingException {
        if (RecipientType.TO == type) {
            return "To";
        }
        if (RecipientType.CC == type) {
            return "Cc";
        }
        if (RecipientType.BCC == type) {
            return "Bcc";
        }
        if (RecipientType.NEWSGROUPS == type) {
            return "Newsgroups";
        }
        throw new MessagingException("Unsupported recipient type: " + type.toString());
    }

    private String getSingleHeader(String name) throws MessagingException {
        String[] values = this.getHeader(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public static class RecipientType
    extends Message.RecipientType {
        public static final RecipientType NEWSGROUPS = new RecipientType("Newsgroups");

        protected RecipientType(String type) {
            super(type);
        }

        protected Object readResolve() throws ObjectStreamException {
            if (this.type.equals("Newsgroups")) {
                return NEWSGROUPS;
            }
            return super.readResolve();
        }
    }
}

