/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.container;

import java.io.File;
import java.io.FileNotFoundException;
import org.apache.cactus.integration.ant.container.AbstractContainer;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

public abstract class AbstractJavaContainer
extends AbstractContainer {
    private File output;
    private boolean append;
    private String jvmArgs;

    public final void setOutput(File theOutput) {
        this.output = theOutput;
    }

    public final void setAppend(boolean isAppend) {
        this.append = isAppend;
    }

    public final void setJVMArgs(String theJVMArgs) {
        this.jvmArgs = theJVMArgs;
    }

    protected final Java createJavaForShutDown() {
        Java java = (Java)this.createAntTask("java");
        java.setFork(true);
        this.addExtraClasspath(java);
        return java;
    }

    protected final Java createJavaForStartUp() {
        Java java = (Java)this.createAntTask("java");
        java.setFork(true);
        java.setOutput(this.output);
        java.setAppend(this.append);
        if (this.jvmArgs != null) {
            this.getLog().trace((Object)("Passing arguments to the container JVM: " + this.jvmArgs));
            java.createJvmarg().setLine(this.jvmArgs);
        }
        this.addExtraClasspath(java);
        if (this.getSystemProperties() != null) {
            for (int i = 0; i < this.getSystemProperties().length; ++i) {
                java.addSysproperty(this.createSysProperty(this.getSystemProperties()[i].getKey(), this.getSystemProperties()[i].getValue()));
            }
        }
        return java;
    }

    private void addExtraClasspath(Java theJavaCommand) {
        Path classpath = theJavaCommand.createClasspath();
        if (this.getContainerClasspath() != null) {
            classpath.addExisting(this.getContainerClasspath());
        }
    }

    protected final Environment.Variable createSysProperty(String theKey, File theFile) {
        Environment.Variable var = new Environment.Variable();
        var.setKey(theKey);
        var.setFile(theFile);
        return var;
    }

    protected final Environment.Variable createSysProperty(String theKey, Path thePath) {
        Environment.Variable var = new Environment.Variable();
        var.setKey(theKey);
        var.setPath(thePath);
        return var;
    }

    protected final Environment.Variable createSysProperty(String theKey, String theValue) {
        Environment.Variable var = new Environment.Variable();
        var.setKey(theKey);
        var.setValue(theValue);
        return var;
    }

    protected final File getToolsJar() throws FileNotFoundException {
        String javaHome = System.getProperty("java.home");
        File toolsJar = new File(javaHome, "../lib/tools.jar");
        if (!toolsJar.isFile()) {
            throw new FileNotFoundException(toolsJar.getAbsolutePath());
        }
        return toolsJar;
    }

    protected final void addToolsJarToClasspath(Path theClasspath) {
        if (!this.isOSX()) {
            try {
                theClasspath.createPathElement().setLocation(this.getToolsJar());
            }
            catch (FileNotFoundException fnfe) {
                this.getLog().warn((Object)"Couldn't find tools.jar (needed for JSP compilation)");
            }
        }
    }

    protected final String getJVMArgs() {
        return this.jvmArgs;
    }

    private boolean isOSX() {
        return System.getProperty("mrj.version") != null;
    }
}

