/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.io.File;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.tomcat.AbstractTomcatContainer;

public abstract class AbstractCatalinaContainer
extends AbstractTomcatContainer {
    private String version;

    protected void init() {
        if (this.getConfiguration().getPropertyValue("cargo.tomcat.shutdown.port") == null) {
            this.getConfiguration().setProperty("cargo.tomcat.shutdown.port", "8205");
        }
    }

    protected final String getVersion(String defaultVersion) {
        String version = this.version;
        if (version == null) {
            try {
                JarFile catalinaJar = new JarFile(new File(this.getHomeDir(), "server/lib/catalina.jar"));
                ZipEntry entry = catalinaJar.getEntry("org/apache/catalina/util/ServerInfo.properties");
                if (entry != null) {
                    Properties props = new Properties();
                    props.load(catalinaJar.getInputStream(entry));
                    String serverInfo = props.getProperty("server.info");
                    if (serverInfo.indexOf(47) > 0) {
                        version = serverInfo.substring(serverInfo.indexOf(47) + 1);
                    }
                } else {
                    version = "4.0.x";
                }
            }
            catch (Exception e) {
                version = defaultVersion;
                this.getMonitor().debug("Failed to find Tomcat version, base error [" + e.getMessage() + "]", this.getClass().getName());
            }
            this.getMonitor().info("Parsed Tomcat version = [" + version + "]", this.getClass().getName());
            this.version = version;
        }
        return version;
    }

    protected final void invokeContainer(String action, Java java) throws Exception {
        java.addSysproperty(this.getAntUtils().createSysProperty("catalina.home", this.getHomeDir()));
        java.addSysproperty(this.getAntUtils().createSysProperty("catalina.base", this.getConfiguration().getDir()));
        File tempFile = new File(this.getConfiguration().getDir(), "temp");
        java.addSysproperty(this.getAntUtils().createSysProperty("java.io.tmpdir", tempFile));
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(this.getHomeDir(), "bin/bootstrap.jar"));
        this.addToolsJarToClasspath(classpath);
        java.setClassname("org.apache.catalina.startup.Bootstrap");
        java.createArg().setValue(action);
        AntContainerExecutorThread catalinaRunner = new AntContainerExecutorThread(java);
        catalinaRunner.start();
    }
}

