/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util.monitor;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.codehaus.cargo.util.monitor.Monitor;

public class AntMonitor
implements Monitor {
    private Project project;
    private Target target;
    private Task task;

    public AntMonitor(Task task) {
        this.project = task.getProject();
        this.task = task;
    }

    public AntMonitor(Target target) {
        this.project = target.getProject();
        this.target = target;
    }

    public AntMonitor(Project project) {
        this.project = project;
    }

    public void debug(String message, String category) {
        this.log(message, 4);
    }

    public void info(String message, String category) {
        this.log(message, 2);
    }

    public void warn(String message, String category) {
        this.log(message, 1);
    }

    private void log(Object messageObj, int logLevel) {
        String message = String.valueOf(messageObj);
        if (this.task != null) {
            this.project.log(this.task, message, logLevel);
        } else if (this.target != null) {
            this.project.log(this.target, message, logLevel);
        } else {
            this.project.log(message, logLevel);
        }
    }
}

