package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.util.Util;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * XFormsitemvfguditemvfɕϊ܂B
 * qvfꏏɕϊ܂Blabel->name, value->valueɕϊ܂B
 * @author nakajo
 */
public class Item2Item extends AbstractTransformer {

	protected GudBuilder builder;
	protected Element current;

	public Item2Item(GudBuilder builder) {
		this.builder = builder;
	}

	/* ( Javadoc)
	 * @see jp.haw.grain.transform.Transformer#isTarget(org.w3c.dom.Node)
	 */
	protected boolean isTarget(Node node) {
		if (node.getNodeType() != Node.ELEMENT_NODE)
			return false;

		Element e = (Element)node;
		if (e.getNamespaceURI() != GudBuilder.XFORMS_NS)
			return false;

		return e.getLocalName() == "item";
	}

	/* ( Javadoc)
	 * @see jp.haw.grain.transform.Transformer#transform(org.w3c.dom.Node, org.w3c.dom.Document)
	 */
	public DocumentFragment transform() {
		Document dom = builder.getGudDoc();
		DocumentFragment df = dom.createDocumentFragment();
		Element xforms_item = (Element)node;
		Element gud_item = dom.createElementNS(GudBuilder.GUD_NS, "item");

		NodeList labels = Util.getNamedChildNode(xforms_item, GudBuilder.XFORMS_NS, "label");
		NodeList values = Util.getNamedChildNode(xforms_item, GudBuilder.XFORMS_NS, "value");

		Element gud_name = dom.createElementNS(GudBuilder.GUD_NS, "name");
		Element gud_value = dom.createElementNS(GudBuilder.GUD_NS, "value");

		if (labels.getLength() > 0) {
			if (!(labels.item(0).getTextContent() == null || labels.item(0).getTextContent().equals(""))) {
				gud_name.setTextContent(labels.item(0).getTextContent()); // ŏlabel̃eLXgRs[
				gud_item.appendChild(gud_name);
			}
		}
		if (values.getLength() > 0) {
			if (!(values.item(0).getTextContent() == null || values.item(0).getTextContent().equals(""))) {
				gud_value.setTextContent(values.item(0).getTextContent()); // ŏvaluẽeLXgRs[
				gud_item.appendChild(gud_value);
			}
		}

		//labels, valuesSskipListɓo^
		registSkipList(labels);
		registSkipList(values);


		//labelvalueȂꍇ͕ϊʂnullɂ
		if (gud_item.getChildNodes().getLength() == 0) {
			this.current = null;
			return null;
		}

		df.appendChild(gud_item);
		this.current = null;

		return df;

	}

	protected void registSkipList(NodeList list) {
		for (int i = 0; i < list.getLength(); i++) {
			Node skipNode = list.item(i);
			builder.addSkipNode(skipNode);

			//̎qvfׂ͂ăXLbvXgɓo^
			NodeList childChildren = skipNode.getChildNodes();
			for (int j = 0; j < childChildren.getLength(); j++) {
				builder.addSkipNode(childChildren.item(j));
			}
		}

	}

	/* ( Javadoc)
	 * @see jp.haw.grain.transform.Transformer#getCurrentNode()
	 */
	public Element getCurrentElement() {
		// TODO ꂽ\bhEX^u
		return this.current;
	}

}
