package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.util.TargetNode;
import jp.haw.grain.transform.util.Util;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * Xformsvfgudvfɕϊ邽߂̃NXłB
 * {Iȕϊ@\񋟂܂B
 * XFormsvf͂̃IuWFNgŕϊ\łB
 * 
 * ÃIuWFNgłnamespaceURIXFormsł邩ǂ
 * f܂BK؂<code>TargetNode</code>w肷Kv܂B
 * 
 * ܂AϊɑRs[̋Ǝqvflabelinlineւ̓WJ
 * ݒł܂B
 * ftHg͂ǂtrueƂȂĂ܂B
 * ϊ̗vfqvfǂɂĂݒł܂B
 * qvfȂ(false)Ɛݒ肵ꍇgetCurrentElement\bhnullԂ܂B
 * @author nakajo
 */
public class XFormsElementTransformer extends ElementHasLabelBaseTransformer {

	protected Element current;
	protected TargetNode targetNode;
	protected String gudElementName;
	protected boolean transformChildLabel;
	protected boolean isCopyAttrs;
	protected boolean havableChild;
	
	/**
	 * ϊΏۂTargetNodew肵XFormsElementTransformerIuWFNg𐶐܂B
	 * ̃Rs[Alabel̓WJtrueɂȂĂ܂B
	 * @param builder
	 * @param targetNode
	 */
	public XFormsElementTransformer(GudBuilder builder, TargetNode targetNode) {
		this.builder = builder;
		this.targetNode = targetNode;
		
		this.transformChildLabel = true;
		this.isCopyAttrs = true;
		this.havableChild = true;
	}

	/**
	 * ϊΏۂTargetNodeƕϊ̗vfw肵XFormsElementTransformerIuWFNg𐶐܂B
	 * ̃Rs[Alabel̓WJtrueɂȂĂ܂B
	 * 
	 * @param builder
	 * @param targetNode
	 * @param elementName
	 */
	public XFormsElementTransformer(GudBuilder builder, TargetNode targetNode, String elementName) {
		this(builder, targetNode);
		this.gudElementName = elementName;
	}

	/* ( Javadoc)
	 * @see xsltest.Transformer#isTarget(org.w3c.dom.Node)
	 */
	protected boolean isTarget(Node node) {
		return targetNode.equals(node);
	}

	/* ( Javadoc)
	 * @see xsltest.Transformer#transform(org.w3c.dom.Node)
	 */
	public DocumentFragment transform() {
		Document dom = builder.getGudDoc();

		DocumentFragment df = dom.createDocumentFragment();

		Element gud = dom.createElementNS(GudBuilder.GUD_NS, this.gudElementName);
		Element xforms = (Element)node;

		//textboxinput̑Rs[
		if(this.isCopyAttrs)
			Util.copyAttributes(xforms, gud);

		//input̎qvflabelinlineɕϊ
		if(this.transformChildLabel)
			transformLabel(df, xforms);
		
		df.appendChild(gud);

		
		this.current = gud;
		
		return df;
	}

	/* ( Javadoc)
	 * @see jp.haw.grain.transform.Transformer#getCurrentNode()
	 */
	public Element getCurrentElement() {
		if(!this.havableChild) return null;
		
		return this.current;
	}
	
	/**
	 * ϊgudvf擾܂B
	 * @return
	 */
	public String getGudElementName() {
		return gudElementName;
	}

	/**
	 * Rs[pɐݒ肳Ă邩ǂԂ܂B
	 * @return
	 */
	public boolean isCopyAttrs() {
		return isCopyAttrs;
	}

	/**
	 * qvflabelinlinevfƂēWJ邩ǂԂ܂B
	 * @return
	 */
	public boolean isTransformChildLabel() {
		return transformChildLabel;
	}

	/**
	 * ϊgudvfݒ肵܂B
	 * @param string
	 */
	public void setGudElementName(String string) {
		gudElementName = string;
	}

	/**
	 * Rs[邩ݒ肵܂B
	 * @param b
	 */
	public void setCopyAttrs(boolean b) {
		isCopyAttrs = b;
	}

	/**
	 * qvflabelinlinevfƂēWJ邩ݒ肵܂B
	 * @param b
	 */
	public void setTransformChildLabel(boolean b) {
		transformChildLabel = b;
	}

	/**
	 * ϊ̗vfqvfĂ邩ǂԂ܂B
	 * @return
	 */
	public boolean isHavableChild() {
		return havableChild;
	}

	/**
	 * ϊ̗vfqvfĂ邩ǂݒ肵܂B
	 * falseݒ肷ƁAgetCurrentElementnullԂ悤ɂȂ܂B
	 * @param b
	 */
	public void setHavableChild(boolean b) {
		havableChild = b;
	}

}
