/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.transformer.AbstractTransformer;
import jp.haw.grain.transform.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Body2View
extends AbstractTransformer {
    protected GudBuilder builder;
    protected Element current;

    public Body2View(GudBuilder builder) {
        this.builder = builder;
    }

    protected boolean isTarget(Node node) {
        if (node.getNodeType() != 1) {
            return false;
        }
        Element e = (Element)node;
        if (e.getNamespaceURI() != "http://www.w3.org/1999/xhtml") {
            return false;
        }
        return e.getLocalName().equals("body");
    }

    public DocumentFragment transform() {
        Document dom = this.builder.getGudDoc();
        DocumentFragment df = dom.createDocumentFragment();
        Element gud_view = dom.createElementNS("http://grain.jp/gud/", "view");
        Document xhtmlDoc = this.node.getOwnerDocument();
        NodeList titleList = xhtmlDoc.getElementsByTagNameNS("http://www.w3.org/1999/xhtml", "title");
        if (titleList.getLength() > 0) {
            gud_view.setAttribute("title", titleList.item(0).getFirstChild().getNodeValue());
        }
        Util.copyAttributes((Element)this.node, gud_view);
        df.appendChild(gud_view);
        this.current = gud_view;
        return df;
    }

    public Element getCurrentElement() {
        return this.current;
    }
}

