/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.transformer.AbstractTransformer;
import jp.haw.grain.transform.util.TargetNode;
import jp.haw.grain.transform.util.Util;
import jp.haw.grain.xpath.compiler.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class P2InlineBlock
extends AbstractTransformer {
    protected GudBuilder builder;
    protected Element current;

    public P2InlineBlock(GudBuilder builder) {
        this.builder = builder;
    }

    public Element getCurrentElement() {
        return this.current;
    }

    protected boolean isTarget(Node node) {
        if (node.getNodeType() != 1) {
            return false;
        }
        if (!"http://www.w3.org/1999/xhtml".equals(node.getNamespaceURI())) {
            return false;
        }
        if (!Util.parentNodeAs(node, new TargetNode("http://www.w3.org/1999/xhtml", "body", 1))) {
            return false;
        }
        return node.getLocalName().equals("p");
    }

    public DocumentFragment transform() {
        Document dom = this.builder.getGudDoc();
        DocumentFragment df = dom.createDocumentFragment();
        Element xhtml_p = (Element)this.node;
        Element gud_inlineblock = dom.createElementNS("http://grain.jp/gud/", "inline-block");
        Util.copyAttributes(xhtml_p, gud_inlineblock);
        try {
            Util.compileRef(gud_inlineblock);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        df.appendChild(gud_inlineblock);
        this.current = gud_inlineblock;
        return df;
    }
}

