/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/19 16:48:31
 * 
 */
package jp.grain.spike.event;

import jp.grain.spike.Node;
import jp.grain.sprout.ui.FormContext;

/**
 * TODO Event
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class Event {

	public static final String NAME_SPACE = "http://www.w3.org/2001/xml-events";

	// 4.2 Cxg
	public static final String TYPE_XFORMS_MODEL_CONSTRUCT = "xforms-model-construct";
	public static final String TYPE_XFORMS_MODEL_CONSTRUCT_DONE = "xforms-model-construct-done";
	public static final String TYPE_XFORMS_READY = "xforms-ready";
	public static final String TYPE_XFORMS_MODEL_DESTRUCT = "xforms-model-destruct";
	// 4.3ݍpCxg
	public static final String TYPE_XFORMS_PREVIOUS = "xforms-previous";
	public static final String TYPE_XFORMS_NEXT = "xforms-next";
	public static final String TYPE_XFORMS_FOCUS = "xforms-focus";
	public static final String TYPE_XFORMS_HELP = "xforms-help";
	public static final String TYPE_XFORMS_HINT = "xforms-hint";
	public static final String TYPE_XFORMS_REBUILD = "xforms-rebuild";
	public static final String TYPE_XFORMS_REFRESH = "xforms-refresh";
	public static final String TYPE_XFORMS_REVALIDATE = "xforms-revalidate";
	public static final String TYPE_XFORMS_RECALCULATE = "xforms-recalculate";
	public static final String TYPE_XFORMS_RESET = "xforms-reset";
	public static final String TYPE_XFORMS_SUBMIT = "xforms-submit";
	// 4.4ʒmCxg
	public static final String TYPE_DOMACTIVATE = "DOMActivate";
	public static final String TYPE_XFORMS_VALUE_CHANGED = "xforms-value-changed";
	public static final String TYPE_XFORMS_SELECT = "xforms-select";
	public static final String TYPE_XFORMS_DESELECT = "xforms-deselect";
	public static final String TYPE_XFORMS_SCROLL_FIRST = "xforms-scroll-first";
	public static final String TYPE_XFORMS_SCROLL_LAST = "xforms-scroll-last";
	public static final String TYPE_XFORMS_INSERT = "xforms-insert";
	public static final String TYPE_XFORMS_DELETE = "xforms-delete";
	public static final String TYPE_XFORMS_VALID = "xforms-valid";
	public static final String TYPE_XFORMS_INVALID = "xforms-invalid";
	public static final String TYPE_DOMFOCUSIN = "DOMFocusIn";
	public static final String TYPE_DOMFOCUSOUT = "DOMFocusOut";
	public static final String TYPE_XFORMS_READONLY = "xforms-readonly";
	public static final String TYPE_XFORMS_READWRITE = "xforms-readwrite";
	public static final String TYPE_XFORMS_REQUIRED = "xforms-required";
	public static final String TYPE_XFORMS_OPTIONAL = "xforms-optional";
	public static final String TYPE_XFORMS_ENABLED = "xforms-enabled";
	public static final String TYPE_XFORMS_DISABLED = "xforms-disabled";
	public static final String TYPE_XFORMS_IN_RANGE = "xforms-in-range";
	public static final String TYPE_XFORMS_OUT_OF_RANGE = "xforms-out-of-range";
	public static final String TYPE_XFORMS_SUBMIT_DONE = "xforms-submit-done";
	public static final String TYPE_XFORMS_SUBMIT_ERROR = "xforms-submit-error";
	// 4.5\
	public static final String TYPE_XFORMS_BINDING_EXCEPTION = "xforms-binding-exception";
	public static final String TYPE_XFORMS_LINK_EXCEPTION = "xforms-link-exception";
	public static final String TYPE_XFORMS_LINK_ERROR = "xforms-link-error";
	public static final String TYPE_XFORMS_COMPUTE_EXCEPTION = "xforms-compute-exception";

	// GraingCxg ANVvf
	public static final String TYPE_GRAIN_RIGHT = "grain-right"; /* L[ꂽƂ̃Cxg */
	public static final String TYPE_GRAIN_LEFT = "grain-left"; /* L[ꂽƂ̃Cxg */
	public static final String TYPE_GRAIN_CANCEL = "grain-cancel"; /* ̓LZCxg */
	public static final String TYPE_GRAIN_IME_COMMITED = "grain-ime-commited"; /* IME͂̃Cxg */
	public static final String TYPE_GRAIN_INPUT_COMMITED = "grain-input-commited"; /* ͂̃Cxg */

	/**
	 * GraingCxg Rg[ANVn̑Cxg<br>
	 * ̃Cxg͓Ɋeꂽ{^ɑΉCxgێ܂<br>
	 * 
	 * ex)<br>
	 * TYPE_XFORMS_PREVIOUS<br>
	 * TYPE_XFORMS_NEXT<br>
	 * TYPE_XFORMS_FOCUS<br>
	 * TYPE_DOMACTIVATE<br>
	 * TYPE_DOMFOCUSIN<br>
	 * TYPE_DOMFOCUSOUT<br>
	 * TYPE_GRAIN_RIGHT<br>
	 * TYPE_GRAIN_LEFT<br>
	 * TYPE_GRAIN_CANCEL<br>
	 */
	public static final String TYPE_GRAIN_ACTION_EVENT = "grain-action-event"; /* L[͂ɑ΂ĔsCxg */

	/** Default Event ɃL[͂ɂ蔭CxgCX^X */
	private static Event _defaultEvent = new Event(true);

	/** ̃Cxg̏ԕύX邩ǂ false: true:s */
	protected boolean _finalize = false;
	/** ̃Cxg̔킵܂ */
	protected Node _owner;
	/** ̃Cxg̃^[QbgIdł */
	protected String _targetId;
	/** FormContextIuWFNg */
	protected FormContext _context;
	/** ̃Cxg̎ʂ킵܂ */
	protected String _type;
	/** ̃CxgouCxgǂ킵܂ */
	protected boolean _bubbles;
	/** ̃CxgLZ\ǂ킵܂ */
	protected boolean _cancelable;
	protected boolean _preventDefault;

	/** ̃Cxg̔ƂȂEventIuWFNg */
	protected Event _triggerEvent;

	public Event(String type, Node owner, String targetId, boolean bubbles, boolean cancelable, FormContext ctx) {
		_type = type;
		_owner = owner;
		_targetId = targetId;
		_bubbles = bubbles;
		_cancelable = cancelable;
		_context = ctx;
	}

	public Event(String type, boolean bubbles, boolean cancelable) {
		_type = type;
		_owner = null;
		_targetId = null;
		_bubbles = bubbles;
		_cancelable = cancelable;
	}

	/**
	 * ̃Cxg̔vƂȂEventIuWFNgݒ肵ĐV EventIuWFNg𐶐܂B bubbles,
	 * cancelableɂĂ͔vEventIuWFNgp܂B
	 * 
	 * @param type
	 * @param owner
	 * @param event
	 */
	public Event(String type, Node owner, Event event) {
		_type = type;
		_owner = owner;
		_triggerEvent = event;
		_bubbles = event.isBubbles();
		_cancelable = event.isCancelable();
		_context = event.getContext();
	}

	/**
	 * ̃Cxg̔vƂȂEventIuWFNg, bubbles, cancelableݒ肵ĐV
	 * EventIuWFNg𐶐܂B
	 * 
	 * @param type
	 * @param owner
	 * @param event
	 */
	public Event(String type, Node owner, Event event, boolean bubbles, boolean cancelable) {
		_type = type;
		_owner = owner;
		_triggerEvent = event;
		_bubbles = bubbles;
		_cancelable = cancelable;
		_context = event.getContext();
	}

	/**
	 * ԕύX\ǂݒ肵EventIuWFNg쐬܂B
	 * 
	 * @param finalize
	 */
	private Event(boolean finalize) {
		this(null, null, null, false, false, null);
		_finalize = finalize;
	}

	public static Event createRefreshEvent(FormContext ctx) {
		Event._defaultEvent._context = ctx;
		Event._defaultEvent._type = Event.TYPE_XFORMS_REFRESH;
		Event._defaultEvent._bubbles = true;
		Event._defaultEvent._cancelable = true;
		Event._defaultEvent._targetId = null;
		Event._defaultEvent._owner = null;
		
		return Event._defaultEvent;
	}
	
	public static Event createEvent(FormContext ctx, int action, int selector) {
		// contexti{^́j甭Cxg͏ɂPȂ̂
		// eʁExdĂłstatic instanceg܂킷B

		if (action == FormContext.ACT_RELEASED) {
			if (selector == FormContext.SEL_DOWN) {
				// 4.3.1 The xforms-next and xforms-previous Events
				Event._defaultEvent._context = ctx;
				Event._defaultEvent._type = Event.TYPE_XFORMS_NEXT;
				Event._defaultEvent._bubbles = false;
				Event._defaultEvent._cancelable = true;
				Event._defaultEvent._targetId = null;
			} else if (selector == FormContext.SEL_UP) {
				// 4.3.1 The xforms-next and xforms-previous Events
				Event._defaultEvent._context = ctx;
				Event._defaultEvent._type = Event.TYPE_XFORMS_PREVIOUS;
				Event._defaultEvent._bubbles = false;
				Event._defaultEvent._cancelable = true;
				Event._defaultEvent._targetId = null;
			} else if (selector == FormContext.SEL_RIGHT) {
				Event._defaultEvent._context = ctx;
				Event._defaultEvent._type = Event.TYPE_GRAIN_RIGHT;
				Event._defaultEvent._bubbles = false;
				Event._defaultEvent._cancelable = true;
				Event._defaultEvent._targetId = null;
			} else if (selector == FormContext.SEL_LEFT) {
				Event._defaultEvent._context = ctx;
				Event._defaultEvent._type = Event.TYPE_GRAIN_LEFT;
				Event._defaultEvent._bubbles = false;
				Event._defaultEvent._cancelable = true;
				Event._defaultEvent._targetId = null;
			} else if (selector == FormContext.SEL_SELECT) {
				Event._defaultEvent._context = ctx;
				Event._defaultEvent._type = Event.TYPE_DOMACTIVATE;
				Event._defaultEvent._bubbles = false;
				Event._defaultEvent._cancelable = true;
				Event._defaultEvent._targetId = null;
			} else if (selector == FormContext.SEL_CANCEL) {
				Event._defaultEvent._context = ctx;
				Event._defaultEvent._type = Event.TYPE_GRAIN_CANCEL;
				Event._defaultEvent._bubbles = false;
				Event._defaultEvent._cancelable = true;
				Event._defaultEvent._targetId = null;
			} else {
				return null;
			}
		} else if (action == FormContext.ACT_IME_RESULT) {
			if (selector == FormContext.SEL_IME_CANCEL) {
				Event._defaultEvent._context = ctx;
				Event._defaultEvent._type = Event.TYPE_GRAIN_CANCEL;
				Event._defaultEvent._bubbles = true;
				Event._defaultEvent._cancelable = true;
				Event._defaultEvent._targetId = null;
			} else if (selector == FormContext.SEL_IME_COMMIT) {
				Event._defaultEvent._context = ctx;
				Event._defaultEvent._type = Event.TYPE_GRAIN_IME_COMMITED;
				Event._defaultEvent._bubbles = true;
				Event._defaultEvent._cancelable = true;
				Event._defaultEvent._targetId = null;
			} else {
				return null;
			}
			Event inputCommited = new Event(Event.TYPE_GRAIN_INPUT_COMMITED, null, Event._defaultEvent);
			return inputCommited;
		} else {
			return null;
		}

		Event actionEvent = new Event(Event.TYPE_GRAIN_ACTION_EVENT, null, Event._defaultEvent);
		actionEvent._finalize = true;
		return actionEvent;
	}

	public boolean isPreventDefault() {
		return _preventDefault;
	}

	public String getType() {
		return _type;
	}

	public boolean isBubbles() {
		return _bubbles;
	}

	public void setBubbles(boolean _bubbles) {
		if (_finalize) return;
		this._bubbles = _bubbles;
	}

	public boolean isCancelable() {
		return _cancelable;
	}

	public void setCancelable(boolean _cancelable) {
		if (_finalize) return;
		this._cancelable = _cancelable;
	}

	public Node getOwner() {
		return _owner;
	}

	public void setOwner(Node _owner) {
		if (_finalize) return;
		this._owner = _owner;
	}

	public String getTargetId() {
		return _targetId;
	}

	public void setTargetId(String id) {
		if (_finalize) return;
		_targetId = id;
	}

	public void setType(String _type) {
		if (_finalize) return;
		this._type = _type;
	}

	public FormContext getContext() {
		return _context;
	}

	public Event getTriggerEvent() {
		return _triggerEvent;
	}

	/**
	 * ̃Cxg̏ԂύX\ǂԂ܂B
	 * 
	 * @return
	 */
	public boolean isFinalize() {
		return this._finalize;
	}
}
