/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/30 16:17:44
 * 
 */
package jp.grain.spike.xpath;

import java.util.Stack;
import java.util.Vector;

import jp.grain.spike.DefaultElement;
import jp.grain.spike.Element;
import jp.grain.spike.Node;
import jp.grain.sprout.ui.ContextNodeset;

/**
 * TODO XPathElement
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class XPathElement extends DefaultElement {

    public static final String STRING = "string";
    public static final String OPERATION = "operator";
    
    /**
     * @param name
     */
    public XPathElement(String name) {
        super(name);
        // TODO Auto-generated constructor stub
    }

    /**
     * @param ctx 
     * @param pc
     * @param stack
     * @return
     */
    public int execute(ContextNodeset ctx, int pc, Stack stack) {
        String name = getName();
        if (name.equals(STRING)) {
            stack.push(getAttribute("value"));
            return ++pc;
        } else if (name.equals(OPERATION)) {
            return executeOperation(ctx, getAttribute("name"), pc, stack);
        }
        return ++pc;
    }

    /**
     * @param pc
     * @param stack
     * @return
     */
    private int executeOperation(ContextNodeset ctx, String name, int pc, Stack stack) {
        if (name == null) {
            // evaluate as NOP
        } else if (name.equals("storectxnode")) {
            stack.push(ctx.getNodeset());
        } else if (name.equals("nametest")) {
            String axis = (String)stack.pop();
            stack.push(name);
            Vector result = new Vector();
            if (axis.equals("child")) {
                stepChildAxis(stack, result);
            } else {
                stack.pop();
                stack.pop();
                stack.pop();
            }
            
            
            Node[] nodes = new Node[result.size()];
            result.copyInto(nodes);
            stack.push(nodes);
        }
        return ++pc;
    }
    
    private void stepChildAxis(Stack stack, Vector result) {
        String type = (String)stack.pop();
        String param = (String)stack.pop();
        Node[] ctxNodes = (Node[])stack.pop();
        for (int i = 0; i < ctxNodes.length; ++i) {
            if (!(ctxNodes[i] instanceof Element)) continue;
            Element elem = (Element)ctxNodes[i];
            for (int j = 0; j < elem.getChildCount(); ++j) {
                Element child = elem.getChildElement(j);
                if (child == null) continue;
                if (nodeTest(child, type, param)) {
                    result.addElement(child);
                }
            }
        }        
    }
    
    private boolean nodeTest(Object node, String type, String param) {
        if (type.equals("nametest")) {
            if (node instanceof Element) {
                if (param.equals("*")) return true;
                return ((Element)node).getName().equals(param);                
//          } else if (!(node instanceof Attribute)) {              
            }
        }
        return false;
    }
}
