package jp.grain.sprout.ui;

import java.util.Vector;

import jp.grain.sprout.model.InstanceElement;

/**
 * @author nakajo
 */
public class Select extends SelectComponent {

	public static final String NAME = "select";

	public Select() {
		super(NAME);
		this._isMultiple = true;
	}

	protected void initSelected() {
		if (getBindingNode() == null) return;
		String[] strs = splitSpace(getBindingNode().getSimpleContent());
		for (int i = 0; i < strs.length; i++) {
			for (int j = 0; j < getChildCount(); j++) {
				Item item = (Item) getChildElement(j);
				if (item == null) continue;
				if (item.getValue().equals(strs[i])) {
					this._currentIndex = j;
					break;
				}
			}
		}
	}

	protected void commitValue() {
		if (getBindingNode() == null) return;
		getBindingNode().setSimpleContent(joinSpace(_selections));
	}

	/**
	 * vectorString𔼊pXy[Xŋ؂Ԃ܂B
	 * 
	 * @param vector
	 * @return
	 */
	private String joinSpace(Vector vector) {
		StringBuffer result = new StringBuffer(vector.size());
		for (int i = 0; i < vector.size(); i++) {
			result.append(vector.elementAt(i).toString());
		}

		return result.toString();
	}

	/**
	 * m[h̕𔼊pXy[Xŋ؂Ă̌ʂzĕԂ܂B
	 * 
	 * @param text
	 * @return
	 */
	private String[] splitSpace(String text) {
		if (text == null) return new String[0];
		text.trim();
		if (text.length() == 0) return new String[0];

		Vector list = new Vector();
		int space = 0;
		while (space != -1) {
			space = text.indexOf(" ");
			if (space == -1) {
				if (text.length() > 0) list.addElement(text);
			} else {
				list.addElement(text.substring(0, space).trim());
				text = text.substring(space, text.length()).trim();
			}
		}

		String[] result = new String[list.size()];
		list.copyInto(result);
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.haw.grain.sprout.Renderer#draw(jp.haw.grain.sprout.DrawContext)
	 */
	public void draw(DrawContext dc) {
		int sx, sy, sw, sh, tmpChildCount = 0;
		dc.clearClip();
		sw = _width + (_padding + _border) * 2;

		// DavidHou
		if ((tmpChildCount = getChildCount()) > getMaxDisplayChildCount()) tmpChildCount = getMaxDisplayChildCount();

		sh = (_font.getHeight() + _padding * 2) * tmpChildCount + _border * 2;
		int spaceConstant = 8 + _font.getHeight();
		// FOCUS
		if (getOwnerForm().isFocusingOn(this) && !_activate) {
			dc.setColor(COLOR_FOCUS);
			dc.drawRect(0, 0, getBoxWidth() + spaceConstant + SIZE_ARROW - 1, sh);
		}

		dc.setColor(COLOR_BLACK);
		if (getChildCount() == 0) return;
		// BOX
		dc.setEmbossParam(_border, COLOR_FIELD, COLOR_EDGE_DARK, COLOR_EDGE_LIGHT, false);
		dc.drawEmbossedRect(_margin, _margin, _width + (_padding + _border) * 2 + spaceConstant + SIZE_ARROW, sh - 1);
		InstanceElement node = (InstanceElement) getBindingNode();
		// disablȅ
		if (node != null && !node.isRelevant()) {
			dc.setColor(0xD2D2D2);
			dc.fillRect(_margin + _border, _margin + _border, _width - (_padding + _border) + spaceConstant + SIZE_ARROW, sh - (_border + _padding));
			dc.setColor(COLOR_BLACK);
		} else {
			// XN[o[̕`
			dc.setEmbossParam(SIZE_ARROW_EDGE, COLOR_BUTTON, COLOR_EDGE_LIGHT, COLOR_EDGE_DARK, _pressed || _activate);
			int ax = _width + (_padding + _border) * 2 + spaceConstant;
			int ay = _margin + _border;
			// XN[o[̕` ܂
			// XN[o[̃XN[
			int embossHeight = sh - (_padding + _border);
			int addHeight = 0;
			if (getMaxDisplayChildCount() < getChildCount()) {
				int scrollStep = getChildCount() - getMaxDisplayChildCount();
				addHeight = embossHeight / getChildCount();
				embossHeight = embossHeight - (addHeight * scrollStep);
				System.out.println("CHOICE: maxHeight=" + (_height + _padding * 2));
				System.out.println("CHOICE: addHeight=" + addHeight);
			}
			int embossY = ay + (addHeight * getDisplayStart());

			dc.drawEmbossedRect(ax, embossY, SIZE_ARROW, embossHeight);
			// XN[o[̃XN[ ܂
		}
		// ITEMS & SHADE
		sx = _border + spaceConstant;
		sy = _border;
		sw = _padding * 2 + _width;
		sh = _padding * 2 + _font.getHeight();

		// DavidHou
		for (int i = getDisplayStart(); i < getDisplayEnd(); ++i) {
			Item item = (Item) getChildElement(i);
			if (i == _currentIndex && _activate) {
				dc.setColor(COLOR_FOCUS);
				dc.fillRect(sx - spaceConstant + 1, sy + 1, sw + spaceConstant, sh);
				dc.setColor(COLOR_FIELD);
			} else {
				dc.setColor(COLOR_BLACK);
			}
			// CHECK
			if (_selections.contains(new Integer(i))) {
				dc.drawLine(_padding + 5, _padding + _font.getHeight() + sy - 5, _padding + 7, _padding + _font.getHeight() + sy - 3); // \
				dc.drawLine(_padding + 7, _padding + _font.getHeight() + sy - 3, _padding + _font.getHeight() - 3, _padding + sy + 3); // /
			}
			// CHECKBOX
			dc.drawRect(_padding * 2, (sy + _padding), _font.getHeight(), _font.getHeight());
			dc.drawString(item.getLabel(), sx + _padding, sy + _padding);
			sy += sh;
		}

		// required̏
		if (node != null && node.isRequired()) {
			dc.setColor(0xFF0000);
			dc.drawString("*", _width + (_padding + _border) * 2 + spaceConstant + SIZE_ARROW + _margin, getContentY());
		}

	}

}
