/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.transform.transformer;

import java.util.regex.Pattern;
import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.transformer.AbstractTransformer;
import jp.haw.grain.transform.util.TargetNode;
import jp.haw.grain.transform.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Text2Inline
extends AbstractTransformer {
    public Text2Inline(GudBuilder builder) {
        super(builder);
    }

    public Element getCurrentElement() {
        return null;
    }

    protected boolean isTarget(Node node) {
        if (node.getNodeType() != 3) {
            return false;
        }
        if (!Util.parentNodeAs(node, new TargetNode("http://www.w3.org/1999/xhtml", "body", 1))) {
            return false;
        }
        return !Pattern.matches("^\\s*$", node.getNodeValue());
    }

    protected boolean isXHTMLBody(Node node) {
        if (node.getNodeType() != 1) {
            return false;
        }
        if (!"http://www.w3.org/1999/xhtml".equals(node.getNamespaceURI())) {
            return false;
        }
        return "body".equals(node.getLocalName());
    }

    public DocumentFragment transform() {
        Document dom = this.builder.getGudDoc();
        DocumentFragment df = dom.createDocumentFragment();
        Element gud_inline = dom.createElementNS("http://grain.jp/gud/", "inline");
        Text inline_text = dom.createTextNode(Util.normalizedString(this.node.getNodeValue()));
        gud_inline.appendChild(inline_text);
        df.appendChild(gud_inline);
        return df;
    }
}

