package jp.haw.grain.dom;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public class NodeWrapper implements Node , NodeList {

	protected Node node;
	protected List children;
	protected Node parent;
	
	public NodeWrapper(Node n) {
		this.node = n;
		this.children = new ArrayList();
	}

	public Node getNode() {
		return this.node;
	}
	
	public Node appendChild(Node arg0) throws DOMException {
		return this.node.appendChild(arg0);
	}

	public Node cloneNode(boolean arg0) {
		return this.node.cloneNode(arg0);
	}

	public short compareDocumentPosition(Node arg0) throws DOMException {
		return this.node.compareDocumentPosition(arg0);
	}

	public NamedNodeMap getAttributes() {
		return this.node.getAttributes();
	}

	public String getBaseURI() {
		return this.node.getBaseURI();
	}

	public NodeList getChildNodes() {
		return this;
	}

	public Object getFeature(String arg0, String arg1) {
		return this.node.getFeature(arg0, arg1);
	}

	public Node getFirstChild() {
		return this.node.getFirstChild();
	}

	public Node getLastChild() {
		return this.node.getLastChild();
	}

	public String getLocalName() {
		return this.node.getLocalName();
	}

	public String getNamespaceURI() {
		return this.node.getNamespaceURI();
	}

	public Node getNextSibling() {
		return this.node.getNextSibling();
	}

	public String getNodeName() {
		return this.node.getNodeName();
	}

	public short getNodeType() {
		return this.node.getNodeType();
	}

	public String getNodeValue() throws DOMException {
		return this.node.getNodeValue();
	}

	public Document getOwnerDocument() {
		return this.node.getOwnerDocument();
	}

	public Node getParentNode() {
		return this.parent;
	}

	public String getPrefix() {
		return this.node.getPrefix();
	}

	public Node getPreviousSibling() {
		return this.node.getPreviousSibling();
	}

	public String getTextContent() throws DOMException {
		return this.node.getTextContent();
	}

	public Object getUserData(String arg0) {
		return this.node.getUserData(arg0);
	}

	public boolean hasAttributes() {
		return this.node.hasAttributes();
	}

	public boolean hasChildNodes() {
		return this.node.hasChildNodes();
	}

	public Node insertBefore(Node arg0, Node arg1) throws DOMException {
		return this.node.insertBefore(arg0, arg1);
	}

	public boolean isDefaultNamespace(String arg0) {
		return this.node.isDefaultNamespace(arg0);
	}

	public boolean isEqualNode(Node arg0) {
		return this.node.isEqualNode(arg0);
	}

	public boolean isSameNode(Node arg0) {
		return this.node.isSameNode(arg0);
	}

	public boolean isSupported(String arg0, String arg1) {
		return this.node.isSupported(arg0, arg1);
	}

	public String lookupNamespaceURI(String arg0) {
		return this.node.lookupNamespaceURI(arg0);
	}

	public String lookupPrefix(String arg0) {
		return this.node.lookupPrefix(arg0);
	}

	public void normalize() {
		this.node.normalize();
		
	}

	public Node removeChild(Node arg0) throws DOMException {
		return this.node.removeChild(arg0);
	}

	public Node replaceChild(Node arg0, Node arg1) throws DOMException {
		return this.node.replaceChild(arg0, arg1);
	}

	public void setNodeValue(String arg0) throws DOMException {
		this.node.setNodeValue(arg0);
	}

	public void setPrefix(String arg0) throws DOMException {
		this.node.setPrefix(arg0);
	}

	public void setTextContent(String arg0) throws DOMException {
		this.node.setTextContent(arg0);
	}

	public Object setUserData(String arg0, Object arg1, UserDataHandler arg2) {
		return this.node.setUserData(arg0, arg1, arg2);
	}

	public int getLength() {
		return this.children.size();
	}

	public Node item(int arg0) {
		return (Node)this.children.get(arg0);
	}

}
