package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.util.TargetNode;
import jp.haw.grain.transform.util.Util;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/**
 * xformsmodelvfƂ̎qvfׂĂRs[܂B
 * @author nakajo
 */
public class ModelChildCopy extends AbstractTransformer {
	
	public ModelChildCopy(GudBuilder builder) {
		super(builder);
	}
	
	public Element getCurrentElement() {
		return this.current;
	}

	protected boolean isTarget(Node node) {
		
		TargetNode xformsModelTarget = new TargetNode(GudBuilder.XFORMS_NS, "model", Node.ELEMENT_NODE);
		if(xformsModelTarget.equals(node)) return true; //̃m[hgmodelvfłOK
		
		//m[hmodelvfȂ̂Őemodelvf邩ׂB
		//ȂΑΏۊO
		return Util.parentNodeAs(node, xformsModelTarget);
	}

	public DocumentFragment transform() {
		Document dom = builder.getGudDoc();
		if(this.node.getNodeType() == Node.ELEMENT_NODE)
			return elementTransform(dom);
			
		if(this.node.getNodeType() == Node.TEXT_NODE)
			return textTransform(dom);
			
		return null;
	}

	protected DocumentFragment elementTransform(Document dom) {
		DocumentFragment df = dom.createDocumentFragment();

		Element any = (Element)node;
		Element gud = null;
		if(any.getNamespaceURI() != null && any.getNamespaceURI() != GudBuilder.XFORMS_NS) {
			gud = dom.createElementNS(any.getNamespaceURI(), node.getLocalName());
			gud.setPrefix(any.getPrefix());
		} else if(any.getNamespaceURI() == null){
			gud = dom.createElementNS("", node.getLocalName());
		} else {
			gud = dom.createElementNS(GudBuilder.GUD_NS, node.getLocalName());
		}
		
		Util.copyAttributes(any, gud);
		
		df.appendChild(gud);
		this.current = gud;
		return df;
	}
	
	protected DocumentFragment textTransform(Document dom) {
		this.current = null;
		if(Util.normalizedString(this.node.getNodeValue()).equals("")) return null;
		
		DocumentFragment df = dom.createDocumentFragment();
		Text gud = dom.createTextNode(Util.normalizedString(this.node.getNodeValue()));
		
		df.appendChild(gud);
		
		return df;
	}
}
