package jp.haw.grain.transform.transformer;

import java.util.regex.Pattern;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.util.TargetNode;
import jp.haw.grain.transform.util.Util;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/**
 * @author nakajo
 */
public class Text2Inline extends AbstractTransformer {
	
	public Text2Inline(GudBuilder builder) {
		super(builder);
	}
	

	/* ( Javadoc)
	 * @see jp.haw.grain.transform.AbstractTransformer#getCurrentElement()
	 */
	public Element getCurrentElement() {
		// TODO ꂽ\bhEX^u
		return null;
	}

	/* ( Javadoc)
	 * @see jp.haw.grain.transform.AbstractTransformer#isTarget(org.w3c.dom.Node)
	 */
	protected boolean isTarget(Node node) {
		if(node.getNodeType() != Node.TEXT_NODE) return false;
		
		//xhtml:bodyȉ̗vf[ƂɂB
		if(!Util.parentNodeAs(node, new TargetNode(GudBuilder.XHTML_NS, "body", Node.ELEMENT_NODE)))
			return false;
		return !Pattern.matches("^\\s*$", node.getNodeValue()); //󔒂݂̂text͑ΏۊO
	}

	/**
	 * m[h
	 * @param node
	 * @return
	 */
	protected boolean isXHTMLBody(Node node) {
		if(node.getNodeType() != Node.ELEMENT_NODE) return false;
		if(!GudBuilder.XHTML_NS.equals(node.getNamespaceURI())) return false;
		
		return "body".equals(node.getLocalName());
	}
	
	/* ( Javadoc)
	 * @see jp.haw.grain.transform.Transformer#transform()
	 */
	public DocumentFragment transform() {
		Document dom = builder.getGudDoc();
		
		DocumentFragment df = dom.createDocumentFragment();
		
		Element gud_inline = dom.createElementNS(GudBuilder.GUD_NS, "inline");
		//Rs[B
		Text inline_text = dom.createTextNode(Util.normalizedString(node.getNodeValue()));
		gud_inline.appendChild(inline_text);
		df.appendChild(gud_inline);
		return df;
	}
}
