package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.util.Util;
import jp.haw.grain.xpath.compiler.ParseException;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * XFormstextareavfgudinputvfɕϊ܂B
 * inputvf̑multiline=trueɂĕs̓͂\܂B
 * inputvf̎qvfłlabelKwς邽߁Aꏏinline֕ϊ܂B
 * @author nakajo
 */
public class Textarea2Textbox extends ElementHasLabelBaseTransformer {
	
	public Textarea2Textbox(GudBuilder builder) {
		super(builder);
	}
	
	/* ( Javadoc)
	 * @see xsltest.Transformer#isTarget(org.w3c.dom.Node)
	 */
	protected boolean isTarget(Node node) {
		if(node.getNodeType() != Node.ELEMENT_NODE) return false;
		
		Element e = (Element)node;
		if(e.getNamespaceURI() != GudBuilder.XFORMS_NS) return false;
		
		return e.getLocalName().equals("textarea");
	}

	/* ( Javadoc)
	 * @see xsltest.Transformer#transform(org.w3c.dom.Node)
	 */
	public DocumentFragment transform() {
		Document dom = builder.getGudDoc();
		
		DocumentFragment df = dom.createDocumentFragment();
		
		Element gud_textbox = dom.createElementNS(GudBuilder.GUD_NS, "textbox");
		Element xforms_textarea = (Element)node;
		
		//textboxinput̑Rs[
		//ref΂pC
		Util.copyAttributes(xforms_textarea, gud_textbox);
		try {
			Util.compileNodeBinding(gud_textbox);
		} catch (ParseException e) {
			throw new RuntimeException(e);
		}
		
		//multiline=trueǉ
		gud_textbox.setAttribute("multiline", "true");
		
		//input̎qvflabelinlineɕϊ
		transformLabel(df, xforms_textarea);
		df.appendChild(gud_textbox);
		
		this.current = gud_textbox;
		return df;
	}

	/* ( Javadoc)
	 * @see jp.haw.grain.transform.Transformer#getCurrentNode()
	 */
	public Element getCurrentElement() {
		// TODO ꂽ\bhEX^u
		return this.current;
	}
	
}
